<?php $__env->startSection('title','Buy -  Subscription'); ?>
<?php $__env->startSection('header_extra'); ?>
<style>
    #card-errors{
        color: red;
        margin-top: 5px;
        font-weight: bold;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


<div class="row">
    <div class="col-12">
        <div class="card-box">
            <h4 class="m-t-0 header-title"><b>Buy - <?php echo e($package->name); ?></b></h4>
            

            <div class="row">
                <div class="col-lg-5 col-xs-12">
                    <div class="p-20">
                        <?php echo $__env->make('widget/notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        
                        
                        
                        <form id="paymentForm" class="form-horizontal" action="<?php echo e(route('customer.payment.post-subscription',$package->id)); ?>" method="post">
                        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                        <div class="form-group row">
                            <h4>Enter Credit Card Details</h4>
                        </div>
                        <div class="form-group row">
                            <div id="card-errors" role="alert"></div>
                        </div>
                        <div class="form-group row">
                            <label>Card Holder Name <span class="text-danger">*</span></label>
                            <input id="card-holder-name" type="text" class="form-control" required="">
                        </div>

                        <div class="form-group row">
                            <!-- Stripe Elements Placeholder -->
                            <div id="card-element" class="form-control" style='height: 2.4em; padding-top: .7em;'></div>
                            
                        </div>
                            
                        <div class="form-group">
                            <div class="col-xs-9 col-xs-offset-3">
                                <button id="card-button" type="submit" class="btn btn-primary" data-secret="<?php echo e($intent->client_secret); ?>">Pay Now</button>
                            </div>
                        </div>
                        
                        </form>
                    </div>
                </div>
                <div class="col-lg-1 col-xs-12"></div>
                <div class="col-lg-5 col-xs-12">
                    <h4 class="m-b-10">Service Details</h4>
                    <table class="table table-bordered">
                        <tr>
                            <th>Service</th>
                            <td>Subscription</td>
                        </tr>
                        <tr>
                            <th>Package Name</th>
                            <td><?php echo e($package->name); ?></td>
                        </tr>
                        <tr>
                            <th>Duration</th>
                            <td><?php echo e($package->duration); ?></td>
                        </tr>
                        <tr>
                            <th>Price</th>
                            <td><?php echo e($package->price); ?></td>
                        </tr>
                        <tr>
                            <th>Tax</th>
                            <td><?php echo e($package->tax); ?></td>
                        </tr>
                        <tr>
                            <th>Total</th>
                            <td><?php echo e($package->grand); ?></td>
                        </tr>
                   </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/formvalidation/0.6.2-dev/js/formValidation.min.js" integrity="sha512-DlXWqMPKer3hZZMFub5hMTfj9aMQTNDrf0P21WESBefJSwvJguz97HB007VuOEecCApSMf5SY7A7LkQwfGyVfg==" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/formvalidation/0.6.2-dev/js/framework/bootstrap.min.js" integrity="sha512-CwWsnPwntKMVNsVVCKIxPd4Ievk/YyAxt/yFNOLbs4JH3W6djpxYf2G50DtxLxFGHIbZxXeVDyjmTT8RCNp8DQ==" crossorigin="anonymous"></script>
<!--<script src="https://js.stripe.com/v2/"></script>-->
<script type="text/javascript">
$(function(){
    $(this).active_menu("subscription");
})
</script>

<script src="https://js.stripe.com/v3/"></script>
<script>
    // Custom styling can be passed to options when creating an Element.
    // (Note that this demo uses a wider set of styles than the guide below.)
    var style = {
        base: {
            color: '#32325d',
            lineHeight: '18px',
            fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
            fontSmoothing: 'antialiased',
            fontSize: '16px',
            '::placeholder': {
                color: '#aab7c4'
            }
        },
        invalid: {
            color: '#fa755a',
            iconColor: '#fa755a'
        }
    };

    const stripe = Stripe('<?php echo e(env("STRIPE_KEY")); ?>', { locale: 'en' }); // Create a Stripe client.
    const elements = stripe.elements(); // Create an instance of Elements.
    const cardElement = elements.create('card', {hidePostalCode: true}, { style: style }); // Create an instance of the card Element.
    const cardButton = document.getElementById('card-button');
    const clientSecret = cardButton.dataset.secret;
    const cardHolderName = document.getElementById('card-holder-name');
    cardElement.mount('#card-element'); // Add an instance of the card Element into the `card-element` <div>.
    
    // Handle real-time validation errors from the card Element.
    cardElement.addEventListener('change', function(event) {
        var displayError = document.getElementById('card-errors');
        if (event.error) {
            displayError.textContent = event.error.message;
        } else {
            displayError.textContent = '';
        }
    });

    // Handle form submission.
    var form = document.getElementById('paymentForm');

    form.addEventListener('submit', function(event) {
        event.preventDefault();

        stripe
            .handleCardSetup(clientSecret, cardElement, {
                payment_method_data: {
                    billing_details: { name: cardHolderName.value,address:{'line1':"<?php echo e(Auth::user()->address); ?>",postal_code:'<?php echo e(Auth::user()->zipcode); ?>',city:'<?php echo e(Auth::user()->city); ?>',state:'<?php echo e(Auth::user()->state); ?>',country:"<?php echo e(Auth::user()->country); ?>"} }
                }
            })
            .then(function(result) {
                console.log(result);
                if (result.error) {
                    // Inform the user if there was an error.
                    var errorElement = document.getElementById('card-errors');
                    errorElement.textContent = result.error.message;
                } else {
                    console.log(result);
                    // Send the token to your server.
                    stripeTokenHandler(result.setupIntent.payment_method);
                }
            });
    });

    // Submit the form with the token ID.
    function stripeTokenHandler(paymentMethod) {
        // Insert the token ID into the form so it gets submitted to the server
        var form = document.getElementById('paymentForm');
        var hiddenInput = document.createElement('input');
        hiddenInput.setAttribute('type', 'hidden');
        hiddenInput.setAttribute('name', 'paymentMethod');
        hiddenInput.setAttribute('value', paymentMethod);
        form.appendChild(hiddenInput);

        // Submit the form
        form.submit();
    }
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/myocanadapanel/public_html/portal/project/resources/views/customer/payment/show.blade.php ENDPATH**/ ?>