<?php $__env->startSection('title','Notification - Add New'); ?>
<?php $__env->startSection('header_extra'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


<div class="row">
    <div class="col-12">
        <div class="card-box">
            <h4 class="m-t-0 header-title"><b>Notification Add New</b></h4>
            <p class="text-muted m-b-30 font-14">
                Required Fields (<code>*</code>)
            </p>

            <div class="row">
                <div class="col-12">
                    <div class="p-20">
                        <?php echo $__env->make('widget/notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        
                        <form class="form-horizontal validate" action="<?php echo e(route('admin.notification.create')); ?>" method="post" role="form" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Particular Customer</label>
                                <div class="col-8">
                                    <select class="form-control select2" name="to_id">
                                        <option value="">All Customer</option>
                                        <?php if(!empty($customer)): ?>
                                        <?php $__currentLoopData = $customer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($c->id); ?>"><?php echo e($c->name.' '.$c->last_name.'('.$c->company_name.')'); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Message <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <textarea class="form-control" name="message" required=""><?php echo e(old('name')); ?></textarea>
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">&nbsp;</label>
                               <div class="col-8">
                                    <div class="checkbox checkbox-primary">
                                        <input id="checkbox2" type="checkbox" name="dashboard" value="1">
                                        <label for="checkbox2">
                                            Show Dashboard
                                        </label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <div class="col-8 offset-4">
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                                        Submit
                                    </button>
                                    
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<script type="text/javascript">
    $('.validate').parsley();
    $(function(){
        $(this).active_menu("notification");
        
    });
    
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aerocodex/public_html/portal/project/resources/views/admin/notification/create.blade.php ENDPATH**/ ?>