@extends('layouts.default')
@section('title','Notification Panel - View')
@section('header_extra')
<link href="{{asset('assets/plugins/summernote/summernote.css')}}" rel="stylesheet" />
@stop

@section('content')
{{read_status($r->id)}}

<div class="row">
    <div class="col-12">
        <div class="card-box">
            <h4 class="m-t-0 header-title"><b>Notification View</b></h4>
           

            <div class="row">
                <div class="col-12">
                    <div class="p-20">
                     
                        
                        <table class="table table-space m-0">
                            @if($r->userinfo_from!="")
                            <tr>
                                <th>From</th>
                                <td>
                                    
                                    {{$r->userinfo_from->name.' '.$r->userinfo_from->name}} <br>
                                    <span class="text-muted"><i>by</i> </span>
                                    @if($r->userinfo_from->role == "1")
                                        <span class="label label-success">Admin</span>
                                    @elseif($r->userinfo_from->role == "2")
                                        <span class="label label-success">Customer</span>
                                    @else 
                                    <span class="label label-success">System</span>
                                    @endif
                                
                                </td>
                            </tr>
                            @endif
                            <tr>
                                <th>Date</th>
                                <td>{{date('m-d-Y h:i a',strtotime($r->created_at))}}</td>
                            </tr>
                            <tr>
                                <th>Message</th>
                                <td>{!! $r->message !!}</td>
                            </tr>
                            
                            <tr>
                                <th></th>
                                <td><a class="btn btn-success" href="{{route('notification.manage')}}">Back</a></td>
                            </tr>
                        </table>
                        
                       
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('footer_scripts')

<script type="text/javascript">
    $(document).ready(function() {
        $(function(){
            $(this).active_menu("notification_pannel");
        });
    });
</script>
@stop