@extends('layouts.default')
@section('title','Order - View')
@section('header_extra')

@stop

@section('content')


<div class="row">
    <div class="col-12">
        <div class="card-box">
            <div class="col-lg-12">
               <h3>Order #{{$r->id}} {!! order_status($r->status) !!}</h3> 
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-6">
        <div class="card-box">
            <h4 class="m-t-0 m-b-30 header-title">Order Information</h4>
            <table class="table table-bordered">
                
                <tr>
                    <th>Payment</th>
                    <td>{{$r->payment}}</td>
                </tr>
                <tr>
                    <th>Payment Status</th>
                    <td>
                        @if($r->payment_status == "Paid")
                        <span class='label label-success'>Paid</span>
                        @else
                        <span class='label label-danger'>{{$r->payment_status}}</span>
                        @endif
                    </td>
                </tr>
                <tr>
                    <th>Transaction ID</th>
                    <td>{{$r->transaction_id}}</td>
                </tr>
                <tr>
                    <th>Transaction Date</th>
                    <td>{{ date('m-d-Y h:i A',  strtotime($r->created_at))}}</td>
                </tr>
                <tr>
                    <th>Order Status</th>
                    <td>{!! order_status($r->status) !!}</td>
                </tr>
            </table>
               
        </div>
    </div>
    
    <div class="col-6">
        <div class="card-box">
            <h4 class="m-t-0 m-b-30 header-title">Service Buy</h4>
            <?php $data= json_decode($r->package_detail);?>
           <table class="table table-bordered">
                <tr>
                    <th>Service</th>
                    <td>
                        @if($r->order_type == "1")
                        Subscription
                        @else
                        Setup Cost 
                        @endif
                    </td>
                </tr>
                <tr>
                    <th>Name</th>
                    <td>{{$data->name}}</td>
                </tr>
                <tr>
                    <th>Duration</th>
                    <td>{{$data->duration}}</td>
                </tr>
                <tr>
                    <th>Price</th>
                    <td>{{$data->price}}</td>
                </tr>
                @if(!empty($invoice))
                <tr>
                    <th>View/Print Invoice</th>
                    <td><a href="{{route('invoice_view',$r->id)}}" style="color: red;"><i class="fa fa-file-pdf-o"></i></a></td>
                </tr>
                @endif
           </table>
        </div>
    </div>
    
    <div class="row mt-2">
        <div class="col-6 mx-auto">
            <a href="{{route('customer.order.manage')}}" class="btn btn-primary">Back</a>
        </div>
    </div>
</div>


@endsection

@section('footer_scripts')

<script type="text/javascript">
    
    $(function(){
        $(this).active_menu("orders");
    });
    
    
</script>
@stop