@extends('layouts.app')

@section('content')


<section>
<div class="container">
    <div class="row">
        <div class="col-sm-12">

            <div class="wrapper-page">

                <div class="account-pages">
                    <div class="account-box">
                        <div class="account-logo-box">
                            <h2 class="text-uppercase text-center">
                                <a href="javascript:void(0)" class="text-success">
                                    <span><img src="{{asset('assets/images/logo_dark.png')}}" alt="" height="30"></span>
                                </a>
                            </h2>
                            <h5 class="text-uppercase font-bold m-b-5 m-t-50">Sign In</h5>
                            <p class="m-b-0">Login to your authorize account</p>
                            
                        </div>
                        <div class="account-content">
                            @include('widget/notifications')
                            <form class="form-horizontal" action="{{ route('login') }}" method="post">
                                @csrf
                                <div class="form-group m-b-20 row @error('email') has-danger @enderror">
                                    <div class="col-12">
                                        <label for="emailaddress">Email address</label>
                                       
                                        <input tabindex="1" id="email" type="email" class="form-control @error('email') form-control-danger @enderror" name="email" value="{{ $email }}" required autocomplete="email" autofocus>
                                        
                                        @error('email')
                                            <div class="form-control-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group row m-b-20 @error('email') has-danger @enderror">
                                    <div class="col-12">
                                        <a href="{{ route('password.request') }}" class="text-muted pull-right"><small>Forgot your password?</small></a>
                                        <label for="password">Password</label>
                                        <input tabindex="2" id="password" type="password" class="form-control @error('password') form-control-danger @enderror" name="password" required autocomplete="current-password" value="{{$password}}">

                                        @error('password')
                                            <div class="form-control-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group row m-b-20">
                                    <div class="col-12">

                                        <div class="checkbox checkbox-success">
                                            <input id="remember" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                                            <label for="remember">
                                                Remember me
                                            </label>
                                        </div>

                                    </div>
                                </div>

                                <div class="form-group row text-center m-t-10">
                                    <div class="col-12">
                                        <button class="btn btn-md btn-block btn-primary waves-effect waves-light" type="submit">Sign In</button>
                                    </div>
                                </div>

                            </form>
                            <div class="row m-t-50">
                                <div class="col-sm-12 text-center">
                                    <p class="text-muted">Don't have an account? <a href="{{route('register')}}" class="text-dark m-l-5"><b>Sign Up</b></a></p>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end card-box-->


            </div>
            <!-- end wrapper -->

        </div>
    </div>
</div>
</section>

@endsection
