@extends('layouts.default')
@section('title','Order - View')
@section('header_extra')

@stop

@section('content')


<div class="row">
    <div class="col-12">
        <div class="card-box">
            <div class="col-lg-12">
               <h3>Order #{{$r->id}} {!! order_status($r->status) !!}</h3> 
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-6">
        <div class="card-box">
            <h4 class="m-t-0 m-b-30 header-title">Order Information</h4>
            <table class="table table-bordered">
                <tr>
                    <th>Customer</th>
                    <td><a target='_blank' href="{{route('admin.user.editForm',$r->user->id)}}">{{$r->user->name .' '.$r->user->last_name}}</a></td>
                </tr>
                <tr>
                    <th>Payment</th>
                    <td>{{$r->payment}}</td>
                </tr>
                <tr>
                    <th>Payment Status</th>
                    <td>
                        @if($r->payment_status == "Paid")
                        <span class='label label-success'>Paid</span>
                        @else
                        <span class='label label-danger'>{{$r->payment_status}}</span>
                        @endif
                    </td>
                </tr>
                <tr>
                    <th>Transaction ID</th>
                    <td>{{$r->transaction_id}}</td>
                </tr>
                <tr>
                    <th>Transaction Date</th>
                    <td>{{ date('m-d-Y h:i A',  strtotime($r->created_at))}}</td>
                </tr>
                <tr>
                    <th>Order Status</th>
                    <td>{!! order_status($r->status) !!}</td>
                </tr>
                
                @if(!empty($invoice))
                <tr>
                    <th>View/Print Invoice</th>
                    <td><a href="{{route('invoice_view',$r->id)}}" style="color: red;"><i class="fa fa-file-pdf-o"></i></a></td>
                </tr>
                @endif
            </table>
               
        </div>
    </div>
    
    <div class="col-6">
        <div class="card-box">
            <h4 class="m-t-0 m-b-30 header-title">Order Action</h4>
               <form class="form-horizontal validate" action="{{route('admin.order.edit_update',$r->id)}}" method="post" role="form" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group row">
                        <label class="col-2 col-form-label">Status <span class="text-danger">*</span></label>
                        <div class="col-8">
                            <select class="form-control" name="status">
                                <option value="0" {{($r->status == "0" ? "selected":"")}}>Completed</option>
                                <option value="2" {{($r->status == "2" ? "selected":"")}}>Refund</option>
                                <option value="3" {{($r->status == "3" ? "selected":"")}}>Cancelled</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-8 offset-4">
                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                Update
                            </button>

                        </div>
                    </div>
               </form>
        </div>
    </div>
</div>


<div class="row">
    <div class="col-12">
        <div class="card-box">
            <h4 class="m-t-0 m-b-30 header-title">Package Purchase</h4>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Days</th>
                        <th>Price</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $data= json_decode($r->package_detail);?>
                    @if(!empty($data))
                    <tr>
                        <td>{{$data->id}}</td>
                        <td>{{$data->name}}</td>
                        <td>{{$data->days}}</td>
                        <td>{{$data->price}}</td>
                        
                    </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection

@section('footer_scripts')

<script type="text/javascript">
    
    $(function(){
        $(this).active_menu("orders");
    });
    
    
</script>
@stop