@extends('layouts.default')
@section('title','Notification - Add New')
@section('header_extra')

@stop

@section('content')


<div class="row">
    <div class="col-12">
        <div class="card-box">
            <h4 class="m-t-0 header-title"><b>Notification Add New</b></h4>
            <p class="text-muted m-b-30 font-14">
                Required Fields (<code>*</code>)
            </p>

            <div class="row">
                <div class="col-12">
                    <div class="p-20">
                        @include('widget/notifications')
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        
                        <form class="form-horizontal validate" action="{{route('admin.notification.create')}}" method="post" role="form" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Particular Customer</label>
                                <div class="col-8">
                                    <select class="form-control select2" name="to_id">
                                        <option value="">All Customer</option>
                                        @if(!empty($customer))
                                        @foreach($customer as $c)
                                        <option value="{{$c->id}}">{{$c->name.' '.$c->last_name.'('.$c->company_name.')' }}</option>
                                        @endforeach
                                        @endif
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Message <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <textarea class="form-control" name="message" required="">{{old('name')}}</textarea>
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">&nbsp;</label>
                               <div class="col-8">
                                    <div class="checkbox checkbox-primary">
                                        <input id="checkbox2" type="checkbox" name="dashboard" value="1">
                                        <label for="checkbox2">
                                            Show Dashboard
                                        </label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <div class="col-8 offset-4">
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                                        Submit
                                    </button>
                                    
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('footer_scripts')
<script type="text/javascript">
    $('.validate').parsley();
    $(function(){
        $(this).active_menu("notification");
        
    });
    
</script>
@stop