<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Calender;

use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\Users as UserResource;
use App\Http\Resources\Calender as CalenderResource;




class CalenderController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){  
        $this->common=new CommonController();
    }

    
    function create(Request $request){
        
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'startDate' => 'required|date_format:Y-m-d h:i',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        
        $input = $request->all();
        
        $input['user_id']=Auth::id();
        $data = new Calender($input);
        if($data->save()){
            return response()->json(['success'=>"Event has been created successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    function update(Request $request,$id){
        $id = decode($id);
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'startDate' => 'required|date_format:Y-m-d h:i',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        
        $input = $request->all();
       
        $data = Calender::find($id);
        if($data->update($input)){
            return response()->json(['success'=>"Event has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    public function single($id=0){
        
        $id = decode($id);
        
        $list['data'] =  CalenderResource::collection(Calender::where('user_id',Auth::id())->where('id',$id)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function show(){
        $list['data'] =  CalenderResource::collection(Calender::where('user_id',Auth::id())->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function delete($id){
        $id = decode($id);
        $delete = Calender::where('user_id',Auth::id())->where('id',$id)->delete();
        if($delete){
            return response()->json(['success'=>'Event has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
        
    }
    

    
    function message_errors(){
        return [
            'title.required'=> 'Title Required',
            'startDate.required'=> 'Please provide the valid start date',
            'startDate.date_format'=> 'Date format should be (YYYY-MM-DD H:M)',
            'endDate.date_format'=> 'Date format should be (YYYY-MM-DD H:M)',
            
        ];
    }
    
}
