<?php

namespace App\Http\Controllers\Api\Associate;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Documents;
use App\Model\Api\DocumentsAssign;
use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\Users as UserResource;
use App\Http\Resources\Documents as DocumentsResource;
use App\Http\Resources\DocumentsAssign as DocumentsAssignResource;



class DocumentsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){  
        $this->common=new CommonController();
    }

    public function show(Request $request){
        $validator = Validator::make($request->all(), [
            'docCategory'=> 'in:Information_Sheets,Document_Checklist'
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
       
        $list['data'] =  DocumentsResource::collection(Documents::where('user_id',secret_key_get())->where('docCategory',$request->input('docCategory'))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    function assign(Request $request){
        
        $validator = Validator::make($request->all(), [
            'docID'=> 'required',
            'studentID'=> 'required',
        ],  $this->message_errors());
        
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        $is_student = \App\User::where('id',  decode($input['studentID']))
                ->where('role',4)
                ->where('owner_key',secret_key_get())
                ->count();
        
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);       
        }
        
        $input['assignedByAgent']=Auth::id();
        $input['assignedByAdmin'] = ownerKeyId(Auth::user()->owner_key);
        $input['studentID'] = decode($input['studentID']);
        $input['docID'] = json_decode($input['docID']);
        
        if(!empty($input['docID'])){
            foreach($input['docID'] as $doc){
                if(!$this->is_assign_doc($doc, $input['studentID'])){
                    $input['docID'] = decode($doc);
                    $data = new DocumentsAssign($input);
                    $data->save(); 
                }
            }
        }
        
        return response()->json(['success'=>"Document has been assigned successfully"], $this->successStatus);
        
    }
    function is_assign_doc($doc_id,$studentID){
       $result =  DocumentsAssign::where('studentID',  $studentID)->where('docID',decode($doc_id))->count();
       return $result;
    }
    
    public function showDocByStudent(Request $request){
        $validator = Validator::make($request->all(), [
            'studentID'=> 'required'
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        
        $input = $request->all();
        
        $is_student = \App\User::where('id',  decode($input['studentID']))
                ->where('role',4)
                ->where('owner_key',secret_key_get())
                ->count();
        
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);       
        }
        $adminID = secret_key_get();
        
        $list['data'] =  DocumentsAssignResource::collection(DocumentsAssign::has('user')->with('user','doc','assignerAdmin')->where('assignedByAdmin',$adminID)->where('studentID',  decode($input['studentID']))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function delete_assign($id){
        $id = decode($id);
        $delete = DocumentsAssign::where('id',$id)->delete();
        if($delete){
            return response()->json(['success'=>'Record has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
        
    }
    
    function message_errors(){
        return [
            'docTitle.required'=> 'Doc Title Required',
            'docFiles.required'=> 'Please provide the valid path of document',
            'docCategory.in' => "Value should be [Information_Sheets,Document_Checklist]",
            'docID.required'=>'Document ID Required',
            'studentID.required'=>'Valid Student ID Required',
        ];
    }
    
}
