<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class ApplicationLog extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => encode($this->id),
            "createddBy" =>  getUserInfo($this->assignedBy,'name').' '.getUserInfo($this->assignedBy,'last_name'),
            "createdType"=>roleName(getUserInfo($this->assignedBy,'role')),
            "description"=>  $this->description,
            'attachemntFile'=> $this->attachment,
            'attachmentURL'=>asset("uploads/applicaiton_notes/"),
            'attachemntFile'=>$this->attachment,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
