<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Application;
use App\Model\Api\Applicationservice;

use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\Users as UserResource;
use App\Http\Resources\Application as ApplicationResource;

use App\Model\Api\ApplicationLog;
use App\Http\Resources\ApplicationLog as ApplicationResourceLog;


class ApplicationController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){
        $this->common=new CommonController();
    }

    function create(Request $request){

        $validator = Validator::make($request->all(), [
            'applyFor' => 'required',
            'studentId' =>'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        $input = $request->all();
        $adminId = 0;
        $is_student_query = \App\User::where('id',  decode($input['studentId']))->where('role',4);
        //if(Auth::user()->role == 2 || Auth::user()->role == 6 || Auth::user()->role ==5 || Auth::user()->role ==7){
            $is_student_query->where('owner_key',secret_key_get());
            $adminId = ownerKeyId( secret_key_get() );
        /*}else{
            $is_student_query->where('owner_key',Auth::user()->owner_key);
            $is_student_query->where('agent_id',Auth::id());
            $adminId = ownerKeyId( secret_key_get() );
        }*/
        $is_student = $is_student_query->count();
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);
        }

        /*if(Auth::user()->role == 7){
            $input['assignTo']=  Auth::id();
        }else{*/
            if($request->input('assign_to')!=""){

                if($request->input('assign_to') !="Admin"){
                    $input['assignTo']=  decode($input['assign_to']);
                }else{
                    $input['assignTo'] = ownerKeyId(secret_key_get());
                }

            }else{
                $input['assignTo'] = 0;
            }

        //}

        if($request->input('status') != ""){
            if($request->input('status') == "Submitted to CIC"){
                $input['decision'] = 'In Processing';
            }
        }

        

        $input['user_id']=  decode($input['studentId']);
        $input['administer_id'] =  $adminId;
        $input['office_application_number'] = $this->applicationNumberGenerate( $input['user_id'], $adminId, $input['applyFor'] );
        //echo "<pre>"; print_r($input); die();
        $data = new Application($input);
        if($data->save()){
            return response()->json(['success'=>"Application has been created successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

    function applicationNumberGenerate($studentId,$adminId,$applyFor){
        $nameLast='';
        $appy='';
        $studentName = getUserInfo($studentId,'name');
        $studentLastName = getUserInfo($studentId,'last_name');
        $name = substr($studentName,0,3);
        if($studentLastName!=""){
            $nameLast = substr($studentLastName,0,2);
        }

        if($applyFor!="Other"){
            $resultAppName = Applicationservice::where('name',$applyFor)->first();
            if(!empty($resultAppName)){
                $appy = $resultAppName->short;
            }
        }else{
            $appy = substr($applyFor,0,2);
        }

        $appidlast = Application::where('administer_id',$adminId)->count();
        return date('Y').$appy.'-'.$nameLast.$name.'-'.($appidlast + 1);
    }

    function update(Request $request,$id){
        $id = decode($id);

        /*if(Auth::user()->role == "7"){
            $Application_is_associate = Application::where('id',$id)->where('assignTo',Auth::id())->count();

            if(!$Application_is_associate){
                return response()->json(['error'=>'This application is not assigned you.'], 401);
            }
        }*/

        $validator = Validator::make($request->all(), [
            'studentId' =>'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }

        $input = $request->all();
        $is_student_query = \App\User::where('id',  decode($input['studentId']))->where('role',4);
        //if(Auth::user()->role == 2 || Auth::user()->role == 6 || Auth::user()->role ==5 || Auth::user()->role ==7) {
            $is_student_query->where('owner_key',secret_key_get());
        /*}else{
            $is_student_query->where('owner_key',Auth::user()->owner_key);
            $is_student_query->where('agent_id',Auth::id());
        }*/
        $is_student = $is_student_query->count();
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);
        }

        if($request->hasFile('uploadDecisionDoc')){
           $input['upload_decision_doc'] = $this->common->fileUpload($request->file('uploadDecisionDoc'),'uploads/application/');
        }

        if($request->input('expire_date') !="" ){
            $input['expire_date'] = date('Y-m-d',strtotime($input['expire_date']));
        }
        if($request->input('decision_date') !=""){
            $input['decision_date'] = date('Y-m-d',strtotime($input['decision_date']));
        }

        //$input['administer_id'] =  ownerKeyId(secret_key_get());

        /*if(Auth::user()->role == "7"){
            $input['assignTo']=  Auth::id();
        }else{*/
            if($request->input('assign_to')!=""){

                if($request->input('assign_to') !="Admin"){
                    $input['assignTo']=  decode($input['assign_to']);
                }else{
                    $input['assignTo'] = ownerKeyId(secret_key_get());
                }

            }else{
                $input['assignTo'] = 0;
            }
        //}

        $data = Application::find($id);
        if($data->update($input)){
            return response()->json(['success'=>"Application has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    public function single($id=0){
        $id = decode($id);
        $query = Application::has('user')->with('user')->where('id',$id);
        // if(Auth::user()->role == "7"){
        //     $query->where('assignTo',Auth::id());
        // }
        $list['data'] =  ApplicationResource::collection($query->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    public function show(Request $request){
        $usersearch =0;
        $data['email']='';
        $data['phone']='';
        $is_agent = '';

        if(count($request->all())){
            $query = Application::has('user')->with('user')->where('administer_id', ownerKeyId( secret_key_get() ));
            if($request->has('phone')){
                $usersearch=1;
                $data['phone'] = $request->input('phone');
            }
            if($request->has('email')){
                $usersearch=1;
                $data['email'] = $request->input('email');
            }


            if($usersearch){
                $query = Application::whereHas('user', function($user) use($data){
                    if($data['phone']!=""){
                        $user->where('phone',$data['phone']);
                    }
                    if($data['email']!=""){
                        $user->where('email',$data['email']);
                    }
                })->with('user');
            }else{
                $query = Application::has('user')->with('user')->where('administer_id', ownerKeyId( secret_key_get() ));
            }


            if($request->has('assign_to')){

                    if($request->input('assign_to') !="Admin"){
                        $query->where('assignTo',decode($request->input('assign_to')));
                    }else{
                        $input['assignedTo'] = ownerKeyId(secret_key_get());
                        $query->where('assignTo',ownerKeyId(secret_key_get()));
                    }

            }
            if($request->has('applyFor')){
                if($request->input('applyFor') == "Other"){
                    $query->where('applyForOther',1);
                }else{
                    $query->where('applyFor',$request->input('applyFor'));
                }
            }
            if($request->has('status')){
                $query->where('status',$request->input('status'));
            }
            if($request->has('decision')){
                $query->where('decision',$request->input('decision'));
            }
            if($request->has('application_no')){
                $query->where('application_number',$request->input('application_no'));
            }
            if($request->has('fee')){
                $query->where('fee',$request->input('fee'));
            }
            if($request->has('student')){
                $query->where('user_id',  decode($request->input('student')));
            }
            if($request->has('appliedDate')){

                $query->whereDate('created_at', date('Y-m-d',   strtotime($request->input('appliedDate'))));
            }
            $application = $query;
        }else{
            $application = Application::has('user')->with('user')->where('administer_id', ownerKeyId( secret_key_get() ));
        }

        // if(Auth::user()->role == "7"){
        //     $application->where('assignTo',Auth::id());
        // }

        if($request->get('page')){
            $list =  ApplicationResource::collection($application->orderBy('id','desc')->paginate(10))->response()->getData();
        }else{
           $list['data'] =  ApplicationResource::collection($application->get());
        }


        return response()->json(['success'=>$list], $this->successStatus);
    }

    public function delete($id){
        $id = decode($id);
        $status = $this->check_status($id);
        $status_name = $this->check_status($id,'info');
        if($status){
            return response()->json(['error'=>'Now your application status is '.$status_name.'. So you can not delete the application.'], 401);
        }

        $delete = Application::where('administer_id',Auth::id())->where('id',$id)->delete();
        if($delete){
            return response()->json(['success'=>'Application has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }

    }

    function check_status($id=0,$return ='status'){
        $query = Application::where('administer_id',Auth::id())->where('id',$id);
        if($return == "status"){
            return $query->whereIn('status',['Review','Document Pending'])->count();
        }else{
            $result = $query->first();
            if(!empty($result)){
                return $result->status;
            }
        }
    }

    /*Application Notes*/
    function notes_create(Request $request,$id){
        $validator = Validator::make($request->all(), [
            'note_description' =>'required',
        ],  $this->message_errors());

        $log['application_id'] = decode($id);
        $log['assignedBy'] = Auth::id();
        $log['assignedType'] = Auth::user()->role;
        if($request->hasFile('attachment')){
            $log['attachment'] = $this->common->fileUpload($request->file('attachment'),'uploads/applicaiton_notes/');
        }

        $log['description'] = $request->input('note_description');
        $dataLog = new ApplicationLog($log);

        if($dataLog->save()){
            return response()->json(['success'=>"Application has been created successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }

    }
    function notes_list($id=0){
        $id = decode($id);
        $list['data'] = ApplicationResourceLog::collection(\App\Model\Api\ApplicationLog::where('application_id',  $id)->orderBy('id','desc')->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    function message_errors(){
        return [
            'fee.in'=>'Fee value should be [Paid,Unpaid]',
            'expire_date'=>'YYYY-MM-DD',
            'studentId'=>'Student ID is required',
            'note_description' => 'Notes  required'

        ];
    }

}
