<?php

namespace App\Http\Controllers\Api\Student;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Notes;
use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\Notes as NotesResource;
use App\Http\Resources\Instruction as InstructionsResource;
use App\Http\Resources\RetrainerAgreement as RetrainerAgreementResource;
use App\Http\Resources\DocumentsAssign as DocumentsAssignResource;
use App\Http\Resources\Users as UserResource;
use App\User;




class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){  
        $this->common=new CommonController();
    }
    
    public function notes_show(){
        $list['data'] =  NotesResource::collection(Notes::with('user','postfrom')->where('postTo',Auth::id())->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    function instruction(){
        $list['data'] =  InstructionsResource::collection(\App\Model\Api\Instruction::get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    function retrainer_agreement(){
        $list['data'] =  RetrainerAgreementResource::collection(\App\Model\Api\RetrainerAgreement::where('studentID',Auth::id())->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    function set_document_list(){
       
        $list['data'] =  DocumentsAssignResource::collection(\App\Model\Api\DocumentsAssign::with('doc')->where('studentID',  Auth::id())->get());
        
      
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    function myprofile_update(Request $request){
        $id = Auth::id();
        $validator = Validator::make($request->all(), [
            'name' => 'required', 'string', 'max:255',
            'email' => 'required|string|email|unique:users,email,'.$id, 
            'phone' => 'required|unique:users,phone,'.$id,
            'sex' => 'in:Male,Female',
            'martialStatus' => 'in:Married,Single,Divorce',
            
        ]);

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
       
        
        $form_data = $request->all();
        if($request->input('new_password') !=""){
            $form_data['password'] = Hash::make($form_data['new_password']);
        }
        $data = User::find($id); 
        if($data->update($form_data)){
            return response()->json(['success'=>'Profile has been updated successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    function set_document_upload(Request $request,$id){
        
        $validator = Validator::make($request->all(), [
            'docCustomer' => 'required|file',
        ]);

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $id = decode($id);
        $file = '';
        $input = $request->all();
        if($request->hasFile('docCustomer')){
           $file = $this->common->fileUpload($request->file('docCustomer'),'uploads/document/student/');
        }
        
        $data = \App\Model\Api\DocumentsAssign::find($id);
        $data->docCustomer = $file;
        if($data->save()){
            return response()->json(['success'=>"Record has been saved successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    
}
