<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use App\Http\Controllers\LeadsController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Communication;
use App\Model\Api\CommunicationLog;
use App\Http\Resources\CommunicationCollection;

use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\Users as UserResource;
use App\Http\Resources\Communication as CommunicationResource;
use App\Http\Resources\CommunicationLog as CommunicationlogResource;
use App\Http\Resources\CommunicationLogSecond as CommunicationlogResourceSecond;
use App\Http\Resources\Leads as LeadsResource;
use App\Model\Api\Leads;
use App\Model\Api\Events;


class CommunicationController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){
        $this->common=new CommonController();
    }


    

    function create(Request $request){

        $validator = Validator::make($request->all(), [
            'source' => 'required',
            'service' =>'required',
            'actionSet' =>'required',
            'studentId' =>'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        $input = $request->all();
        $is_student_query = \App\User::where('id',  decode($input['studentId']))->where('role',4);
        if(Auth::user()->role == 2 || Auth::user()->role == 6 || Auth::user()->role == 5 || Auth::user()->role == 7){
            $is_student_query->where('owner_key',secret_key_get());
        }else{
            $is_student_query->where('owner_key',Auth::user()->owner_key);
            $is_student_query->where('agent_id',Auth::id());
        }
        $is_student = $is_student_query->count();
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);
        }


        $comm['studentId'] =  decode($input['studentId']);

        if($request->has('applicationId')){
            $comm['applicationId'] =  decode($input['applicationId']);
        }
        

        $comm['openBy'] =  Auth::id();
        $comm['source'] = $input['source'];
        $comm['service'] = $input['service'];
        $comm['notes'] = $input['notes'];
        $comm['actionSet'] = $input['actionSet'];
        if($request->has('startDate')){
            $comm['startDate'] = $input['startDate'];
        }
        if($request->has('endDate')){
            $comm['endDate'] = $input['endDate'];
        }
        

        if($request->has('status')){
            $comm['status'] = $input['status'];
        }

        if($request->has('assignedTo')){
            $comm['assignedTo'] = decode($input['assignedTo']);

            if($request->input('assignedTo') !="Admin"){
                $comm['assignedTo'] = decode($input['assignedTo']);
            }else{
                $comm['assignedTo'] = ownerKeyId(secret_key_get());
            }
        }
        if($request->has('resolutionNotes')){
            $comm['resolutionNotes'] = $input['resolutionNotes'];
        }

        $comm['administer_id'] =  ownerKeyId(secret_key_get());
        //echo "<pre>"; print_r($comm); echo "</pre>"; die();

        $data = new Communication($comm);
        if($data->save()){


            /** Appointment */
            if($comm['actionSet'] == "Book an Appointment"){
                $inputAppData['administer_id'] = ownerKeyId(secret_key_get());
                $inputAppData['createdBy'] =Auth::id();
                $inputAppData['client_id'] = $comm['studentId'];
                $inputAppData['clientType'] = 'profile';
                $inputAppData['assignedTo'] = $comm['assignedTo'];
                $inputAppData['type'] = 'Appointment';
                $inputAppData['service'] = $input['service'];
                $inputAppData['startDate'] = $input['startDate'] ;
                $inputAppData['endDate'] =  $input['endDate'] ;
                $inputAppData['title'] = $input['notes'].' -  Via Interaction';
                $inputAppData['notes'] = $input['description'];
                $inputAppData['source'] = $input['source'];
                $dataApp = new Events($inputAppData); 
                $dataApp->save();

                if($request->has('startDate')){
                    $commLog['startDate'] = $input['startDate'];
                }
                if($request->has('endDate')){
                    $commLog['endDate'] = $input['endDate'];
                }
            }

            /*Communication ID update*/

            $commIdObj = Communication::find($data->id);
            $commId = rand(1, 10).$data->id.rand(1, 10);
            $commIdObj->comm_id = $commId;
            $commIdObj->save();

            //if($request->input('actionSet') != "No Action Required"){
                $commLog['communication_id'] = $data->id;
                $commLog['assignedBy'] = Auth::id();
                $commLog['assignedType'] = Auth::user()->role;

                if($request->has('assignedTo')){
                    if($request->input('assignedTo') !="Admin"){
                        $commLog['assignedTo'] = decode($input['assignedTo']);
                    }else{
                        $commLog['assignedTo'] = adminId(secret_key_get());
                    }
                }

                if($request->has('dueDateTime')){
                    $commLog['dueDateTime'] = $input['dueDateTime'];
                }else{
                    $commLog['dueDateTime'] = '';
                }



                $commLog['status'] = $input['status'];
                if($request->has('description')){
                    $commLog['description'] = $input['description'];
                }

                $commLog['replyBy'] = Auth::id();
                $commLog['replyByRole'] = Auth::user()->role;

                if($request->has('resolutionNotes')){
                    $commLog['resolutionNotes'] = $input['resolutionNotes'];
                }
                $dataLog = new CommunicationLog($commLog);
                $dataLog->save();
            //}

            return response()->json(['success'=>"Communication record has been created successfully",'id'=>$commId,'recordID'=>encode($data->id)], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

    function update(Request $request,$id){
        $id = decode($id);

        $input = $request->all();

        if($request->has('source')){
            $comm['source'] = $input['source'];
        }

        if($request->has('service')){
            $comm['service'] = $input['service'];
        }

        $comm['notes'] = $input['notes'];
        $comm['modifyBy'] = Auth::id();

        $data = Communication::find($id);
        if($data->update($comm)){
            return response()->json(['success'=>"Record has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    public function single($id=0){
        $id = decode($id);
        $query = Communication::has('user')->with('user')->where('administer_id',ownerKeyId(secret_key_get()))->where('id',$id);
//        if(Auth::user()->role == 3){
//            $query->where('assignedTo',Auth::id());
//        }
        $list['data'] =  CommunicationResource::collection($query->get());

        $list['leads'] = $this->getLeadsHistory($id);
        return response()->json(['success'=>$list], $this->successStatus);
    }

    function getLeadsHistory($id=0){
        $userId = getUserInfoCommunication($id,'studentId');
        $email = getUserInfo($userId,'email');
        return LeadsResource::collection(Leads::where('email',$email)->get());
    }

    public function show(Request $request){


        $query = Communication::has('user')->with('user')->Where('administer_id',ownerKeyId(secret_key_get()));
        if(count($request->all())){
            if($request->has('student')){
                $query->where('studentId',  decode($request->input('student')));
            }

            if($request->has('commId')){
                $query->where('comm_id',$request->input('commId'));
            }

            if($request->has('assignedTo')){
                $query->where('assignedTo',decode($request->input('assignedTo')));
            }

            if($request->has('service')){
                $query->where('service',$request->input('service'));
            }

            if($request->has('action')){
                $query->where('actionSet',$request->input('action'));
            }

            if($request->has('status')){
                $query->where('status',$request->input('status'));
            }
        }


        if(Auth::user()->role == 3){
            //$query->where('assignedTo',Auth::id());
        }

        if($request->get('page')){
            $list =  CommunicationResource::collection($query->orderBy('id','desc')->paginate(10))->response()->getData();
        }else{
            $list['data'] = CommunicationResource::collection($query->get());
        }
        //$list =  CommunicationResource::collection($query->orderBy('id','desc')->paginate(10))->response()->getData();
        //$list['data'] =  CommunicationResource::collection($query->get());

        return response()->json(['success'=>$list], $this->successStatus);
    }

    function message_errors(){
        return [
            'source'=>'Source value required',
            'service'=>'Service value required',
            'actionSet'=>'Action value required',
            'actionSet.in'=> 'Action value must be [Follow Up,Call Back Requested,No Action Required]',
            'studentId'=>'Student ID required'
        ];
    }

    function is_agent_belong($id=0){
        return Communication::where("id",$id)->where('assignedTo',Auth::id())->count();
    }

    function logCreate(Request $request,$id){
        $id = decode($id);

        $commPrvMain = Communication::where('id',$id)->first();
        $input = $request->all();
//        if(Auth::user()->role == 3 ){
//            if(!$this->is_agent_belong($id)){
//                return response()->json(['error'=>"You have no access to post the data. "], 401);
//            }
//        }



        $comm['actionSet'] = $input['actionSet'];
        $comm['status'] = $input['status'];
        if($request->has('assignedTo') && $input['assignedTo']!=""){

            if($input['assignedTo'] !="Admin"){
                $comm['assignedTo'] = decode($input['assignedTo']);
            }else{
                $comm['assignedTo'] = adminId(secret_key_get());
            }

        }else{
            $comm['assignedTo'] = $commPrvMain->assignedTo;
        }
        if($request->has('resolutionNotes')){
            $comm['resolutionNotes'] = $input['resolutionNotes'];
        }

        if($request->has('startDate')){
            $comm['startDate'] = $input['startDate'];
        }else{
            $comm['startDate'] = '';
        }
        if($request->has('endDate')){
            $comm['endDate'] = $input['endDate'];
        }else{
            $comm['endDate'] = '';
        }

        $data = Communication::find($id);
        if($data->update($comm)){



            /** Appointment */
            if($comm['actionSet'] == "Book an Appointment"){
                $inputAppData['administer_id'] = ownerKeyId(secret_key_get());
                $inputAppData['createdBy'] =Auth::id();
                $inputAppData['client_id'] = $data->studentId;
                $inputAppData['clientType'] = 'profile';
                $inputAppData['assignedTo'] = $comm['assignedTo'];
                $inputAppData['type'] = 'Appointment';
                $inputAppData['service'] = $data->service;
                $inputAppData['startDate'] = $input['startDate'] ;
                $inputAppData['endDate'] =  $input['endDate'] ;
                $inputAppData['title'] = $input['description'].' -  Via Interaction';
                $inputAppData['notes'] = $data->notes;
                $inputAppData['source'] = $data->source;
                $dataApp = new Events($inputAppData); 
                $dataApp->save();

                if($request->has('startDate')){
                    $commLog['startDate'] = $input['startDate'];
                }else{
                    $commLog['startDate']='';
                }
                if($request->has('endDate')){
                    $commLog['endDate'] = $input['endDate'];
                }else{
                    $commLog['endDate'] = '';
                }
            }


            $commLogPrev = CommunicationLog::where('communication_id',$id)->latest()->first();
            $commLog['communication_id'] = $id;


               if($request->has('assignedTo') && $input['assignedTo']!=""){
                    $commLog['assignedBy'] = Auth::id();
                    $commLog['assignedType'] = Auth::user()->role;

                    if($input['assignedTo'] !="Admin"){
                        $commLog['assignedTo'] = decode($input['assignedTo']);
                    }else{
                        $commLog['assignedTo'] = adminId(secret_key_get());
                    }
               }else{

                   $commLog['assignedBy'] = $commLogPrev->assignedBy;
                   $commLog['assignedType'] = $commLogPrev->assignedType;
                   $commLog['assignedTo'] = $commLogPrev->assignedTo;

               }





                $commLog['dueDateTime'] = $input['dueDateTime'];
                $commLog['status'] = $input['status'];
                $commLog['description'] = $input['description'];

                $commLog['replyBy'] = Auth::id();
                $commLog['replyByRole'] = Auth::user()->role;

                if($request->has('resolutionNotes')){
                    $commLog['resolutionNotes'] = $input['resolutionNotes'];
                }

                $dataLog = new CommunicationLog($commLog);
                $dataLog->save();


            return response()->json(['success'=>"Record has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

    public function show_logs(Request $request){
        $query = CommunicationLog::with(['comm_rel'=>function($q){
            $q->Where('administer_id',ownerKeyId(secret_key_get()));
        }]);

        if(count($request->all())){
            if($request->has('follow_date')){
                $query->whereDate('dueDateTime','=', $request->input('follow_date'));
            }
            if($request->has('followstatus')){
                if($request->input('followstatus') !="all"){
                    $query->where('followStatus', $request->input('followstatus'));
                }
            }

            if($request->has('action')){
                if($request->input('action') !="all"){
                    $query->join('communication', function($join)
                    {
                        $join->on('communication.id', '=', 'communication_logs.communication_id');
                    });
                    $query->where('communication.actionSet', $request->input('action'));
                }
            }

            if($request->has('assignedto') && $request->input('assignedto')!=""){
                if($request->input('assignedto') !="Admin"){
                    $query->where('assignedTo',decode($request->input('assignedto')));
                }else{
                    $query->where('assignedTo',adminId(secret_key_get()));
                }
            }
        }
        $list['data'] =  CommunicationlogResourceSecond::collection($query->orderBy('dueDateTime','desc')->get());

        return response()->json(['success'=>$list], $this->successStatus);


    }

    function log_status_update(Request $request,$id){

        $id = decode($id);
        $input = $request->all();
        $comm['followStatus'] = $input['followstatus'];

        $data = CommunicationLog::find($id);
        if($data->update($comm)){
            return response()->json(['success'=>"Record has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

}
