<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class Users extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        switch($this->role){
            case "2":
                return $this->adminInfo();
                break;
            case "3":
                return $this->agentInfo();
                break;
            case "4":
                return $this->studentInfo();
                break;
            case "5":
                return $this->staffInfo();
                break;
            case "6":
                return $this->managerInfo();
                break;
            case "7":
                return $this->associateInfo();
                break;    
            default:
                return response()->json(['error'=>'Error, Invalid reqest.'], 401);
            
        }
        
    }
    function adminInfo(){
        return [
            'id' => encode($this->id),
            'name' => $this->name,
            'last_name' => $this->last_name,
            'email' => $this->email,
            'role'=>'admin',
           
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
    function associateInfo(){
        return [
            'id' => encode($this->id),
            'name' => $this->name,
            'last_name' => $this->last_name,
            'phone' => $this->phone,
            'anotherPhone' => $this->anotherPhone,
            'email' => $this->email,
            'sex' => $this->sex,
            'citizenship' => $this->citizenship,
            'employeeID' => $this->employeeID,
            'city' => $this->city,
            'state' => $this->state,
            'zipcode' => $this->zipcode,
            'district' => $this->district,
            'country' => $this->country,
            'educationDetails' => $this->educationDetails,
            'experience' => $this->experience,
            'address' => $this->address,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'role'=>'associate',
            'status'=> $this->status,
            'two_way_authentication' => $this->two_way_authentication,
            'two_way_authentication_email' => $this->two_way_authentication_email
        ];
    }
    function agentInfo(){
        return [
            'id' => encode($this->id),
            'name' => $this->name,
            'last_name' => $this->last_name,
            'phone' => $this->phone,
            'anotherPhone' => $this->anotherPhone,
            'email' => $this->email,
            'sex' => $this->sex,
            'citizenship' => $this->citizenship,
            'employeeID' => $this->employeeID,
            'city' => $this->city,
            'state' => $this->state,
            'zipcode' => $this->zipcode,
            'district' => $this->district,
            'country' => $this->country,
            'educationDetails' => $this->educationDetails,
            'experience' => $this->experience,
            'address' => $this->address,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'role'=>'agent',
            'status'=> $this->status,
            'two_way_authentication' => $this->two_way_authentication,
            'two_way_authentication_email' => $this->two_way_authentication_email
        ];
    }
    function studentInfo(){
        return [
            'id' => encode($this->id),
            
            $this->mergeWhen(Auth::user()->isCompany(), [
                'agent_id' => encode($this->agent_id),
                'agent_name' => agent_info($this->agent_id,'name').' '.agent_info($this->agent_id,'last_name') 
            ]),
            $this->mergeWhen(Auth::user()->isAssociates(), [
                'agent_id' => encode($this->agent_id),
                'agent_name' => agent_info($this->agent_id,'name').' '.agent_info($this->agent_id,'last_name') 
            ]),
            $this->mergeWhen(Auth::user()->isStaff(), [
                'agent_id' => encode($this->agent_id),
                'agent_name' => agent_info($this->agent_id,'name').' '.agent_info($this->agent_id,'last_name') 
            ]),
            $this->mergeWhen(Auth::user()->isManager(), [
                'agent_id' => encode($this->agent_id),
                'agent_name' => agent_info($this->agent_id,'name').' '.agent_info($this->agent_id,'last_name') 
            ]),
            'name' => $this->name,
            'last_name' => $this->last_name,
            'dateOfbirth' => $this->dateOfbirth,
            'placeBirth' => $this->placeBirth,
            'email' => $this->email,
            'phone' => $this->phone,
            'anotherPhone' => $this->anotherPhone,
            'sex' => $this->sex,
            'citizenship' => $this->citizenship,
            'passportNumber' => $this->passportNumber,
            'martialStatus' => $this->martialStatus,
            'nativeLanguage' => $this->nativeLanguage,
            'address' => $this->address,
            'city' => $this->city,
            'state' => $this->state,
            'zipcode' => $this->zipcode,
            'district' => $this->district,
            'country' => $this->country,
            'mailingAddress' => $this->mailingAddress,
            'educationDetails' => $this->educationDetails,
            'whichCountry' => $this->whichCountry,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'role'=>'student',
            'applyFor'=>  $this->applyFor,
            'applyForOther' => $this->applyForOther,
            'status'=> $this->status,
            'experience' => $this->experience,
            'familyInformation' => $this->familyInformation,
            'mailingAddSame'=> $this->mailingAddSame,
            'profile_enable'=>$this->client_enable,
            'custom_field_data'=>$this->custom_field_data,
        ];
    }
    function staffInfo(){
        return [
            'id' => encode($this->id),
            'name' => $this->name,
            'last_name' => $this->last_name,
            'phone' => $this->phone,
            'anotherPhone' => $this->anotherPhone,
            'email' => $this->email,
            'sex' => $this->sex,
            'citizenship' => $this->citizenship,
            'employeeID' => $this->employeeID,
            'city' => $this->city,
            'state' => $this->state,
            'zipcode' => $this->zipcode,
            'district' => $this->district,
            'country' => $this->country,
            'educationDetails' => $this->educationDetails,
            'experience' => $this->experience,
            'address' => $this->address,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'role'=>'staff',
            'status'=> $this->status,
            'two_way_authentication' => $this->two_way_authentication,
            'two_way_authentication_email' => $this->two_way_authentication_email
        ];
    }
    function managerInfo(){
        return [
            'id' => encode($this->id),
            'name' => $this->name,
            'last_name' => $this->last_name,
            'phone' => $this->phone,
            'anotherPhone' => $this->anotherPhone,
            'email' => $this->email,
            'sex' => $this->sex,
            'citizenship' => $this->citizenship,
            'employeeID' => $this->employeeID,
            'city' => $this->city,
            'state' => $this->state,
            'zipcode' => $this->zipcode,
            'district' => $this->district,
            'country' => $this->country,
            'educationDetails' => $this->educationDetails,
            'experience' => $this->experience,
            'address' => $this->address,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'role'=>'staff',
            'status'=> $this->status,
            'two_way_authentication' => $this->two_way_authentication,
            'two_way_authentication_email' => $this->two_way_authentication_email
        ];
    }
}
