<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class Events extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => encode($this->id),
            'clientId' => encode($this->client_id),
            'clientType' => $this->clientType,
            'clientName' => getUserMultiProfile($this->client_id, $this->clientType,'name').' '.getUserMultiProfile($this->client_id,$this->clientType,'last_name'),
            'clientPhone' => getUserMultiProfile($this->client_id, $this->clientType,'phone'),
            'eventCreateBy' => getUserInfo($this->createdBy,'name').' '.getUserInfo($this->createdBy,'last_name'),
            'eventCreateByRole'=>roleName(getUserInfo($this->createdBy,'role')),
            'service'=>  $this->service,
            'serviceOther'=> $this->serviceOther,
            'startDate'=>  $this->startDate,
            'endDate'=>  $this->endDate,
            'title' => $this->title,
            'notes' => $this->notes,
            'repeat'=>  $this->remind_rpeat,
            'repeatCustom'=>  $this->remind_custom,
            "assignedTo" =>encode($this->assignedTo),
            'assignedToName' => getUserInfo($this->assignedTo,'name').' '.getUserInfo($this->assignedTo,'last_name'),
            'assignedToRole'=>roleName(getUserInfo($this->assignedTo,'role')),
            'source'=>$this->source,
            'type' =>  $this->type,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
