<?php

namespace App\Http\Controllers\Customer;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\CommonController;
use App\User;
use Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Hash;
use Laravel\Cashier\Cashier;



class PaymentController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $tax_rate = 10;
    public function __construct()
    {
        $this->middleware('company.permissions');
        $this->common=new CommonController();
        
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function show(Request $request, $package_id=''){
        $content['pageConfigs'] = ['pageHeader' => true];
        $content['breadcrumbs'] = [
          ["link" => route('customer.home'), "name" => "Home"],["Packages" => route('customer.packages'),"name" => "Packages"],["name" => "Buy Now"]
        ];
        
        $content['intent'] = $request->user()->createSetupIntent();
        $package = \App\Model\Package::where('id',  decode($package_id))->first();
        if(empty($package)){
            $request->session()->flash('error',  ' Invalid package id/Package not found.');
        }
        $content['package'] = $package;
        return view('customer.payment.show',$content);
    }
    public function update_card(Request $request){
        $content['pageConfigs'] = ['pageHeader' => true];
        $content['breadcrumbs'] = [
          ["link" => route('customer.home'), "name" => "Home"],["name" => "Update CARD"]
        ];
        
        $content['intent'] = $request->user()->createSetupIntent();
        return view('customer.payment.update_card',$content);
    }
    
    
    function setup_cost_show(Request $request){
        $content['pageConfigs'] = ['pageHeader' => true];
        $content['breadcrumbs'] = [
          ["link" => route('customer.home'), "name" => "Home"],["name" => "Buy Setup Cost Service"]
        ];
        
        $content['intent'] = $request->user()->createSetupIntent();
        $package = \App\Model\Package::where('type',  2)->first();
        if(empty($package)){
            $request->session()->flash('error',  ' Invalid package id/Package not found.');
        }
        $content['package'] = $package;
        
//        $email['heading'] ='Heading of email informaton';
//        $email['content'][] = "It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using 'Content here, content here', making";
//        $email['content'][] = " <a href='".route('login')."'>Link ifnormation</a> It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using 'Content here, content here', making";
//        $view = View('emailtemplates.notification',$email); 
//        $content =$view->render();
//        echo "<pre>"; print_r($content); echo "</pre>";die();
               
        return view('customer.payment.cost',$content);
    }
    
    public function postSubscription(Request $request,$package_id){
        $user =  User::find(Auth::id());
        $package = \App\Model\Package::where('id',$package_id)->first();
        
        try{
            
            $payment = Auth::user()->newSubscription($package->name,$package->stripe_id)->create($request->paymentMethod);
            if ($user->subscribed($package->name)) {
                $this->cancelSubscribeAll($package_id);
                $data['user_id'] = Auth::id();
                $data['payment'] = $package->price;
                $data['tax'] = $package->tax;
                $data['grand'] = $package->grand;
                $data['payment_status'] = 'Paid';
                $data['transaction_id'] = $payment->stripe_id;
                $data['package_detail'] = json_encode($package);
                $data['order_type'] = 1;
                $order = new \App\Model\Orders($data);
                $order->save();
                $order_id = $order->id;
                
                /*Invoice Generate*/
                $invoice_data['user_id'] = Auth::id();
                $invoice_data['order_id'] = $order->id;
                $invoice_data['customer_information'] = Auth::user()->name. ' '.Auth::user()->last_name. "<br>".Auth::user()->address.'<br>'.Auth::user()->city.','.Auth::user()->state.' <br>'.Auth::user()->country.' '.Auth::user()->zipcode;
                $invoice_data['product_id'] = $package->id;
                $invoice_data['product_information'] = json_encode($package);
                $invoice_data['price'] = $package->price;;
                $invoice_data['tax'] = $package->tax;
                $invoice_data['tax_rate'] = $this->tax_rate;
                $invoice_data['grand_total'] = $package->grand;
                $invoice = $this->common->invoice_save($invoice_data);
                //$this->send_invoice( $invoice->id );
                
                $invoice_content = $this->send_invoice($invoice);
                if($invoice_content!=""){
                    $this->common->sendSMTPSystem(Auth::user()->email, "Invoice - New Subscription Purchase - ".$package->name,$invoice_content);
                    $this->common->sendSMTPSystem(config('constants.notifcation_email'), "Invoice - New Subscription Purchase - ".$package->name,$invoice_content);
                }
                
                
                /*Notification*/
                $notifi['to_id'] = 1;
                $notifi['from_id'] = Auth::id();
                $notifi['type'] ='customer_to_admin';
                $notifi['message'] = 'New subscription purchase <br> Package name: '.$package->name.'<br>Price '.$package->grand.'<br> Transaction ID '.$payment->stripe_id.'<br> <a href="'.route('admin.order.view',$order->id).'">Order ID -  '.$order->id.'</a> ';
                $notification = new \App\Model\Notification($notifi);
                $notification->save();
                
                
                $email['heading'] ='Thanks for new subscription - '.$package->name;
                $email['content'][] = "Thanks for purchase the new subscription. Your subscriptoin has been active successfully";
                $view = View('emailtemplates.notification',$email); 
                $content =$view->render();
                
                $this->common->sendSMTPSystem(Auth::user()->email, "New Subscription Purchase - ".$package->name,$content);
                $this->common->sendSMTPSystem(config('constants.notifcation_email'), "New Subscription Purchase - ".$package->name,$content);
                
                $request->session()->flash('success', 'Successfully subscribed');
                return redirect(route('customer.profile'));
            }
            
        }catch (\Stripe\Exception\IncompletePayment $exception){
            $request->session()->flash('error',  $exception->payment->id.' .. Oop something went wrong.');
            return redirect()->back();
        }catch(\Stripe\Exception\CardException $e) {
            $request->session()->flash('error',  'Error - '.$e->getError()->message);
            return redirect()->back();
        } catch (\Stripe\Exception\RateLimitException $e) {
              $request->session()->flash('error',  'Error - '.$e->getError()->message);
              return redirect()->back();
        } catch (\Stripe\Exception\InvalidRequestException $e) {
               $request->session()->flash('error',  'Error - '.$e->getError()->message);
               return redirect()->back();
        } catch (\Stripe\Exception\AuthenticationException $e) {
            $request->session()->flash('error',  'Error - '.$e->getError()->message);
            return redirect()->back();
        } catch (\Stripe\Exception\ApiConnectionException $e) {
            $request->session()->flash('error',  'Error - '.$e->getError()->message);
            return redirect()->back();
        } catch (\Stripe\Exception\ApiErrorException $e) {
            $request->session()->flash('error',  'Error - '.$e->getError()->message);
            return redirect()->back();
        }catch (\Stripe\Exception\PaymentFailure $e) {
            $request->session()->flash('error',  'Error - '.$e->getError()->message);
            return redirect()->back();
        } catch (Exception $e) {
            $request->session()->flash('error',  'Error');
            return redirect()->back();
        }
        
        
            
    }
    function send_invoice($id= 0){
        $invoice = \App\Model\Invoice::where('id',$id)->first();
        if(!empty($invoice)){
            $data['r'] = $invoice;
            $view = View('emailtemplates.invoice',$data); 
            $content =$view->render();
            return $content;
        }
    }
    
    function update_card_save(Request $request){
        try{
            $package = Auth::user()->updateDefaultPaymentMethod($request->paymentMethod);
            $request->session()->flash('success', 'Successfully card has been updated');
            
            /*Notification*/
            $notifi['to_id'] = 1;
            $notifi['from_id'] = Auth::id();
            $notifi['type'] ='admin_to_customer';
            $notifi['message'] = 'Client update the card details <br> <a href="'.route('admin.user.editForm',Auth::id()).'">View client details</a> ';
            $notification = new \App\Model\Notification($notifi);
            $notification->save();
            
            
            $email['heading'] ='Credit card update';
            $email['content'][] = "Your credit card has been updated successfully";
            $view = View('emailtemplates.notification',$email); 
            $content =$view->render();

            $this->common->sendSMTPSystem(Auth::user()->email, "Credit Card Information upate ",$content);
            $this->common->sendSMTPSystem(config('constants.notifcation_email'), "Credit Card Information upate",$content);
            
            return redirect()->back();
        }catch (\Stripe\Exception\IncompletePayment $exception){
            $request->session()->flash('error',  $exception->payment->id.' .. Oop something went wrong.');
            return redirect()->back();
        }catch(\Stripe\Exception\CardException $e) {
            $request->session()->flash('error',  'Error - '.$e->getError()->message);
            return redirect()->back();
        } catch (\Stripe\Exception\RateLimitException $e) {
              $request->session()->flash('error',  'Error - '.$e->getError()->message);
              return redirect()->back();
        } catch (\Stripe\Exception\InvalidRequestException $e) {
               $request->session()->flash('error',  'Error - '.$e->getError()->message);
               return redirect()->back();
        } catch (\Stripe\Exception\AuthenticationException $e) {
            $request->session()->flash('error',  'Error - '.$e->getError()->message);
            return redirect()->back();
        } catch (\Stripe\Exception\ApiConnectionException $e) {
            $request->session()->flash('error',  'Error - '.$e->getError()->message);
            return redirect()->back();
        } catch (\Stripe\Exception\ApiErrorException $e) {
            $request->session()->flash('error',  'Error - '.$e->getError()->message);
            return redirect()->back();
        }catch (\Stripe\Exception\PaymentFailure $e) {
            $request->session()->flash('error',  'Error - '.$e->getError()->message);
            return redirect()->back();
        } catch (Exception $e) {
            $request->session()->flash('error',  'Error');
            return redirect()->back();
        }
    }
    
    function setupFeecharge(Request $request){
       $user =  User::find(Auth::id());
       $package = \App\Model\Package::where('id',3)->first();
       $info['description'] = $package->name;
       $price = $package->price;
        try {
            $payment = $user->charge($price,$request->paymentMethod,$info);
            
            $data['user_id'] = Auth::id();
            $data['payment'] = $package->price;
            $data['payment_status'] = 'Paid';
            $data['transaction_id'] = $payment->charges->data[0]->payment_method;
            $data['package_detail'] = json_encode($package);
            $data['order_type'] = 2;
            $order = new \App\Model\Orders($data);
            $order->save();
            $order_id = $order->id;
            
            /*Invoice Generate*/
            $invoice_data['user_id'] = Auth::id();
            $invoice_data['order_id'] = $order->id;
            $invoice_data['customer_information'] = Auth::user()->name. ' '.Auth::user()->last_name. "<br>".Auth::user()->address.'<br>'.Auth::user()->city.','.Auth::user()->state.' <br>'.Auth::user()->country.' '.Auth::user()->zipcode;
            $invoice_data['product_id'] = $package->id;
            $invoice_data['product_information'] = json_encode($package);
            $invoice_data['price'] = $package->price;;
            $invoice_data['tax'] = $package->tax;
            $invoice_data['tax_rate'] = $this->tax_rate;
            $invoice_data['grand_total'] = $package->grand;
           
            $invoice_content = $this->common->invoice_save($invoice_data);
            
            $invoice_content = $this->send_invoice($invoice_content);
            if($invoice_content!=""){
                $this->common->sendSMTPSystem(Auth::user()->email, "Invoice - Setup Fees ",$invoice_content);
                $this->common->sendSMTPSystem(config('constants.notifcation_email'), "Invoice - Setup Fees ",$invoice_content);
            }
            
            /*Notification*/
            $notifi['to_id'] = 1;
            $notifi['from_id'] = Auth::id();
            $notifi['type'] ='customer_to_admin';
            $notifi['message'] = 'Purchase one time setup service <br> Package name: '.$package->name.'<br>Price '.$package->price.'<br> Transaction ID '.$payment->charges->data[0]->payment_method.'<br> <a href="'.route('admin.order.view',$order->id).'">Order ID -  '.$order->id.'</a> ';
            $notification = new \App\Model\Notification($notifi);
            $notification->save();
            
            
            
            $email['heading'] ='Thanks for buy our portal - '.$package->name;
            $email['content'][] = "Thanks for purchase the new our protal. Your protal service has been active successfully.";
            $view = View('emailtemplates.notification',$email); 
            $content =$view->render();

            $this->common->sendSMTPSystem(Auth::user()->email, "New Subscription Purchase - ".$package->name,$content);
            $this->common->sendSMTPSystem(config('constants.notifcation_email'), "New Subscription Purchase - ".$package->name,$content);
            
            $request->session()->flash('success', 'Successfully payment charged');
            return redirect()->back();
            
        } catch(\Stripe\Exception\CardException $e) {
            $request->session()->flash('error',  'Error - '.$e->getError()->message);
            return redirect()->back();
        } catch (\Stripe\Exception\RateLimitException $e) {
              $request->session()->flash('error',  'Error - '.$e->getError()->message);
              return redirect()->back();
        } catch (\Stripe\Exception\InvalidRequestException $e) {
               $request->session()->flash('error',  'Error - '.$e->getError()->message);
               return redirect()->back();
        } catch (\Stripe\Exception\AuthenticationException $e) {
            $request->session()->flash('error',  'Error - '.$e->getError()->message);
            return redirect()->back();
        } catch (\Stripe\Exception\ApiConnectionException $e) {
            $request->session()->flash('error',  'Error - '.$e->getError()->message);
            return redirect()->back();
        } catch (\Stripe\Exception\ApiErrorException $e) {
            $request->session()->flash('error',  'Error - '.$e->getError()->message);
            return redirect()->back();
        } catch (Exception $e) {
            $request->session()->flash('error',  'Error');
            return redirect()->back();
        }
    }
    
    
    function cancelSubscribeAll($package_id_not=0){
        
        $package = \App\Model\Package::where('status',1)->where('type',1)->where('id','!=',$package_id_not)->get();
        if(!empty($package)){
            foreach($package as $p){
                if($this->common->is_subscribe($p->name)){
                    $this->common->cancelSubscriptionNow($p->name);
                }
            }
        }
    }
    
    function cancelSubscription(Request $request, $package=''){
        if($this->common->is_subscribe($package)){
            $this->common->cancelSubscription($package);
            
            /*Notification*/
            $notifi['to_id'] = 1;
            $notifi['from_id'] = Auth::id();
            $notifi['type'] ='admin_to_customer';
            $notifi['message'] = 'Subscription cancelled by customer <br> <a href="'.route('admin.user.editForm',Auth::id()).'">View client details</a> ';
            $notification = new \App\Model\Notification($notifi);
            $notification->save();
            
            
            
            $email['heading'] ='Subscription has been cancelled';
            $email['content'][] = "Your subscription has been cacnelled successfully";
            $view = View('emailtemplates.notification',$email); 
            $content =$view->render();

            $this->common->sendSMTPSystem(Auth::user()->email, "New Subscription Purchase - ".$package->name,$content);
            $this->common->sendSMTPSystem(config('constants.notifcation_email'), "New Subscription Purchase - ".$package->name,$content);
            $request->session()->flash('success', 'Your susbscription will be cancel at the end of the subscription date.');
            return redirect()->back();
        }
    }
    function cancelSubscriptionNow(Request $request, $package=''){
        if($this->common->is_subscribe($package)){
            $this->common->cancelSubscriptionNow($package);
            
            /*Notification*/
            $notifi['to_id'] = 1;
            $notifi['from_id'] = Auth::id();
            $notifi['type'] ='admin_to_customer';
            $notifi['message'] = 'Subscription cancelled (immediate) by customer <br> <a href="'.route('admin.user.editForm',Auth::id()).'">View client details</a> ';
            $notification = new \App\Model\Notification($notifi);
            $notification->save();
            
            
            $request->session()->flash('success', 'Your susbscription has been cancelled.');
            return redirect()->back();
        }
    }
    
    
    
}
