<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Leads;
use App\Model\Api\Application;
use App\User;

use Validator;
use Illuminate\Support\Facades\Hash;
use App\Http\Resources\LeadsSearch as LeadsResource;
use App\Http\Resources\UsersSearch as UserResource;
use App\Http\Resources\ApplicationSearch as ApplicationResource;

use App\Http\Resources\ApplicationApplicantResource as ApplicantResource;


class SearchController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){
        $this->common=new CommonController();
    }


    public function show(Request $request){

        $validator = Validator::make($request->all(), [
            'search' => 'required',
            'searchvalue' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        /** Leads */
        $leadresult = array();
        $userresult = array();
        $applicationresult =array();
        $leadresult =  $this->leads($request);
        $userresult = $this->users($request);
        $applicationresult = $this->application($request);
        $applicantresult = $this->applicant($request);
        if($request->has('search') && $request->input('search') == "applicant"){
            $result = $applicantresult;
        } else {
            $result = $leadresult->merge($userresult);
            $result = $result->merge($applicationresult);
            $result = $result->merge($applicantresult);
        }
        $list['data'] =  collect($result)->sortBy('firstName',SORT_NATURAL)->values()->toArray();
        return response()->json(['success'=>$list, 'search' => $request->input('search')], $this->successStatus);
    }
    function users($request){

        if(count($request->all())){

            if(Auth::user()->role == 3){
                $query = User::where('owner_key',secret_key_get())->where('agent_id',Auth::id())->where('role',4);
            }else{
                $query = User::where('owner_key',secret_key_get())->where('role',4);
            }
            $is_one_search = 0;
            $first_name = $request->input('searchvalue');
            $last_name = $request->input('searchvalue');
            $str = $request->input('searchvalue');
            if ($str == trim($str) && strpos($str, ' ') !== false) {
                $first_name='';
                $last_name='';
                $nameArr = explode(" ",$str);
                $total_space=  count($nameArr);

                if($total_space > 1){
                    $first_name='';
                    for($i=0;$i<$total_space - 1;$i++){
                        $first_name.=$nameArr[$i];
                    }
                    $last_name = $nameArr[$total_space-1];
                }else{
                    $first_name = $nameArr[0];
                    $last_name = $nameArr[1];
                }
                $is_one_search=1;
            }


            if($request->has('search') && $request->input('search') == "all"){

                if($request->has('searchvalue') && $request->input('searchvalue')!=""){

                    if($is_one_search){

                        $query->where('name', 'LIKE', $first_name);
                        $query->where('last_name', 'LIKE',$last_name);
                        //$query->orWhereRaw('LOWER(email) like ?',strtolower($request->input('searchvalue')));
                        $query->where(function($q) use ($request) {
                            $q->orWhereRaw('LOWER(email) like ?','%'.strtolower($request->input('searchvalue')).'%');
                            $q->orWhere('phone', 'like', '%'.$request->input('searchvalue').'%');
                        });
                    }else{
                        $query->where(function($q) use ($request,$first_name,$last_name) {
                            $q->whereRaw('LOWER(email) like ?','%'.strtolower($request->input('searchvalue')).'%');
                            $q->orWhere('name','like', '%'.$first_name.'%');
                            $q->orWhere('last_name','like', '%'.$last_name.'%');
                            $q->orWhere('phone', 'like', '%'.$request->input('searchvalue').'%');
                        });
                    }


                }
            }
            if($request->has('search') && $request->input('search') == "name"){
                if($request->has('searchvalue') && $request->input('searchvalue')!=""){
                    if($is_one_search){
                        $query->where('name', 'LIKE', $first_name);
                        $query->where('last_name', 'LIKE',$last_name);
                    }else{
                        $query->where(function($q) use ($request,$first_name,$last_name) {
                            $q->where('name','like', '%'.$first_name.'%');
                            $q->orWhere('last_name','like', '%'.$last_name.'%');
                        });

                    }

                }
            }

            if($request->has('search') && $request->input('search') == "email"){
                if($request->has('searchvalue') && $request->input('searchvalue')!=""){
                    $query->whereRaw('LOWER(email) like ?','%'.strtolower($request->input('searchvalue')) .'%');
                }
            }
            if($request->has('search') && $request->input('search') == "phone"){
                if($request->has('searchvalue') && $request->input('searchvalue')!=""){
                    $query->where('phone', 'like', '%'.$request->input('searchvalue').'%');
                }
            }
        }
        return  UserResource::collection($query->get());
    }
    function leads($request){

        if(count($request->all())){
            $query = Leads::where('convertStatus',0)->where('administer_id',ownerKeyId(secret_key_get()));


            $first_name = $request->input('searchvalue');
            $last_name = $request->input('searchvalue');
            $str = $request->input('searchvalue');
            $is_one_search = 0;
            if ($str == trim($str) && strpos($str, ' ') !== false) {

                $nameArr = explode(" ",$str);
                $total_space=  count($nameArr);

                //echo $total_space - 1;
                if($total_space > 1){
                    $first_name='';
                    for($i=0;$i<$total_space - 1;$i++){
                        $first_name.=$nameArr[$i];
                    }
                    $last_name = $nameArr[$total_space-1];

                }else{
                    $first_name = $nameArr[0];
                    $last_name = $nameArr[1];
                }
                $is_one_search=1;
            }

            if($request->has('search') && $request->input('search') == "all"){
                if($request->has('searchvalue') && $request->input('searchvalue')!=""){
                    if($is_one_search){
                        $query->where('firstName','like', '%'.$first_name.'%');
                        $query->where('lastName','like', '%'.$last_name.'%');
                        $query->where(function($q) use ($request,$first_name,$last_name) {
                            $q->orWhere('LOWER(email) like ?','%'.strtolower($request->input('searchvalue')).'%');
                            $q->orWhere('phoneNumber', 'like', '%'.$request->input('searchvalue').'%');
                        });
                        //$query->orWhereRaw('LOWER(email) like ?',strtolower($request->input('searchvalue')));

                        //$query->where('phoneNumber', 'like', '%'.$request->input('searchvalue').'%');
                    }else{
                        $query->where(function($q) use ($request,$first_name,$last_name) {
                            $q->whereRaw('LOWER(email) like ?','%'.strtolower($request->input('searchvalue')).'%');
                            $q->orWhere('firstName','like', '%'.$first_name.'%');
                            $q->orWhere('lastName','like', '%'.$last_name.'%');
                            //$q->orWhere('phoneNumber', 'like', '%'.$request->input('searchvalue').'%');
                            $q->orWhere('phoneNumber', 'like', '%'.$request->input('searchvalue').'%');
                        });
                    }


                }
            }


            if($request->has('search') && $request->input('search') == "name"){
                if($request->has('searchvalue') && $request->input('searchvalue')!=""){
                    if($is_one_search){
                        $query->where('firstName','like', '%'.$first_name.'%');
                        $query->where('lastName','like', '%'.$last_name.'%');
                    }else{
                        $query->where(function($q) use ($request,$first_name,$last_name) {
                            $q->where('firstName','like', '%'.$first_name.'%');
                            $q->orWhere('lastName','like', '%'.$last_name.'%');
                        });

                    }
                }
            }

            if($request->has('search') && $request->input('search') == "email"){
                if($request->has('searchvalue') && $request->input('searchvalue')!=""){
                    $query->whereRaw('LOWER(email) like ?','%'.strtolower($request->input('searchvalue')).'%');
                }
            }
            if($request->has('search') && $request->input('search') == "phone"){
                if($request->has('searchvalue') && $request->input('searchvalue')!=""){
                    $query->where('phoneNumber', 'like', '%'.$request->input('searchvalue').'%');
                }
            }
            return  LeadsResource::collection($query->get());
        }

    }

    function application($request){
        if(count($request->all())){
            if($request->has('search') && $request->input('search') == "all"){
                if($request->has('searchvalue') && $request->input('searchvalue') != ""){
                    $query = Application::has('user')->with('user')->where('administer_id', ownerKeyId( secret_key_get() ));
                    $query->where('application_number','like', '%'.$request->input('searchvalue').'%');
                    return  ApplicationResource::collection($query->get());
                }
            }
        }
    }

    function applicant($request){
        if(count($request->all())){
            if($request->has('search') && ($request->input('search') == "all" || $request->input('search') == "applicant")){
                if($request->has('searchvalue') && $request->input('searchvalue') != ""){
                    $query = Application::has('user')->with('user')->where('administer_id', ownerKeyId( secret_key_get() ));
                    $query->where('applicant_name','like', '%'.$request->input('searchvalue').'%');
                    return  ApplicantResource::collection($query->get());
                }
            }
        }
    }

    function message_errors(){
        return [
            'search'=>'Search field can not be blank',
            'searchvalue'=>'Search value required'
        ];
    }



}
