<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\DocIdentity;
use Validator;
use Illuminate\Support\Facades\Hash;

use App\Http\Resources\DocIdentity as DocIdentityResource;
use App\Http\Resources\DocEdcuation as DocEdcuationResource;
use App\Http\Resources\DocWorkExperience as DocWorkExperienceResource;
use App\Http\Resources\DocDigitalPic as DocDigitalPicResource;

use App\Http\Resources\DocResume as DocResumeResource;
use App\Http\Resources\DocFundProof as FundProofResource;
use App\Http\Resources\DocCaReport as DocCaReportResource;
use App\Http\Resources\DocBiz as DocBizResource;
use App\Http\Resources\DocOther as DocOtherResource;

class DocumentsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){  
        $this->common=new CommonController();
    }

    public function identity(Request $request){
        $validator = Validator::make($request->all(), [
            'studentID' => 'required',
            'applicationID' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        $is_student_query = \App\User::where('id',  decode($input['studentID']))->where('role',4);
        if(Auth::user()->role == 2 || Auth::user()->role == 6 || Auth::user()->role == 5 || Auth::user()->role == 7){
            $is_student_query->where('owner_key',secret_key_get());
        }else{
            $is_student_query->where('owner_key',Auth::user()->owner_key);
            $is_student_query->where('agent_id',Auth::id());
        }
        $is_student = $is_student_query->count();
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);       
        }
        
        $list['data'] =  DocIdentityResource::collection(DocIdentity::where('user_id',decode($input['studentID']))->where('application_id',  decode($input['applicationID']))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function education(Request $request){
        $validator = Validator::make($request->all(), [
            'studentID' => 'required',
            'applicationID' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        $is_student_query = \App\User::where('id',  decode($input['studentID']))->where('role',4);
        if(Auth::user()->role == 2 || Auth::user()->role == 6 || Auth::user()->role == 5 || Auth::user()->role == 7){
            $is_student_query->where('owner_key',secret_key_get());
        }else{
            $is_student_query->where('owner_key',Auth::user()->owner_key);
            $is_student_query->where('agent_id',Auth::id());
        }
        $is_student = $is_student_query->count();
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);       
        }
        
        $list['data'] =  DocEdcuationResource::collection(\App\Model\Api\DocEducation::where('user_id',decode($input['studentID']))->where('application_id',  decode($input['applicationID']))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function work_experience(Request $request){
        $validator = Validator::make($request->all(), [
            'studentID' => 'required',
            'applicationID' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        $is_student_query = \App\User::where('id',  decode($input['studentID']))->where('role',4);
        if(Auth::user()->role == 2 || Auth::user()->role == 6 || Auth::user()->role == 5 || Auth::user()->role == 7){
            $is_student_query->where('owner_key',secret_key_get());
        }else{
            $is_student_query->where('owner_key',Auth::user()->owner_key);
            $is_student_query->where('agent_id',Auth::id());
        }
        $is_student = $is_student_query->count();
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);       
        }
        
        $list['data'] =  DocWorkExperienceResource::collection(\App\Model\Api\DocWorkExperience::where('user_id',decode($input['studentID']))->where('application_id',  decode($input['applicationID']))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function digital_picture(Request $request){
        $validator = Validator::make($request->all(), [
            'studentID' => 'required',
            'applicationID' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        $is_student_query = \App\User::where('id',  decode($input['studentID']))->where('role',4);
        if(Auth::user()->role == 2 || Auth::user()->role == 6 || Auth::user()->role == 5 || Auth::user()->role == 7){
            $is_student_query->where('owner_key',secret_key_get());
        }else{
            $is_student_query->where('owner_key',Auth::user()->owner_key);
            $is_student_query->where('agent_id',Auth::id());
        }
        $is_student = $is_student_query->count();
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);       
        }
        
        $list['data'] =  DocDigitalPicResource::collection(\App\Model\Api\DocDegitalPicture::where('user_id',decode($input['studentID']))->where('application_id',  decode($input['applicationID']))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function cv_resume(Request $request){
        $validator = Validator::make($request->all(), [
            'studentID' => 'required',
            'applicationID' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        $is_student_query = \App\User::where('id',  decode($input['studentID']))->where('role',4);
        if(Auth::user()->role == 2 || Auth::user()->role == 6 || Auth::user()->role == 5 || Auth::user()->role == 7){
            $is_student_query->where('owner_key',secret_key_get());
        }else{
            $is_student_query->where('owner_key',Auth::user()->owner_key);
            $is_student_query->where('agent_id',Auth::id());
        }
        $is_student = $is_student_query->count();
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);       
        }
        
        $list['data'] =  DocResumeResource::collection(\App\Model\Api\DocResume::where('user_id',decode($input['studentID']))->where('application_id',  decode($input['applicationID']))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function funds_proof(Request $request){
        $validator = Validator::make($request->all(), [
            'studentID' => 'required',
            'applicationID' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        $is_student_query = \App\User::where('id',  decode($input['studentID']))->where('role',4);
        if(Auth::user()->role == 2 || Auth::user()->role == 6 || Auth::user()->role == 5 || Auth::user()->role == 7){
            $is_student_query->where('owner_key',secret_key_get());
        }else{
            $is_student_query->where('owner_key',Auth::user()->owner_key);
            $is_student_query->where('agent_id',Auth::id());
        }
        $is_student = $is_student_query->count();
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);       
        }
        
        $list['data'] =  FundProofResource::collection(\App\Model\Api\DocFundProof::where('user_id',decode($input['studentID']))->where('application_id',  decode($input['applicationID']))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function ca_report(Request $request){
        $validator = Validator::make($request->all(), [
            'studentID' => 'required',
            'applicationID' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        $is_student_query = \App\User::where('id',  decode($input['studentID']))->where('role',4);
        if(Auth::user()->role == 2 || Auth::user()->role == 6 || Auth::user()->role == 5 || Auth::user()->role == 7){
            $is_student_query->where('owner_key',secret_key_get());
        }else{
            $is_student_query->where('owner_key',Auth::user()->owner_key);
            $is_student_query->where('agent_id',Auth::id());
        }
        $is_student = $is_student_query->count();
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);       
        }
        
        $list['data'] =  DocCaReportResource::collection(\App\Model\Api\DocCaReport::where('user_id',decode($input['studentID']))->where('application_id',  decode($input['applicationID']))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function business_doc(Request $request){
        $validator = Validator::make($request->all(), [
            'studentID' => 'required',
            'applicationID' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        $is_student_query = \App\User::where('id',  decode($input['studentID']))->where('role',4);
        if(Auth::user()->role == 2 || Auth::user()->role == 6 || Auth::user()->role == 5 || Auth::user()->role == 7){
            $is_student_query->where('owner_key',secret_key_get());
        }else{
            $is_student_query->where('owner_key',Auth::user()->owner_key);
            $is_student_query->where('agent_id',Auth::id());
        }
        $is_student = $is_student_query->count();
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);       
        }
        
        $list['data'] =  DocBizResource::collection(\App\Model\Api\DocBusiness::where('user_id',decode($input['studentID']))->where('application_id',  decode($input['applicationID']))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function others_doc(Request $request){
        $validator = Validator::make($request->all(), [
            'studentID' => 'required',
            'applicationID' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        $is_student_query = \App\User::where('id',  decode($input['studentID']))->where('role',4);
        if(Auth::user()->role == 2 || Auth::user()->role == 6 || Auth::user()->role == 5 || Auth::user()->role == 7){
            $is_student_query->where('owner_key',secret_key_get());
        }else{
            $is_student_query->where('owner_key',Auth::user()->owner_key);
            $is_student_query->where('agent_id',Auth::id());
        }
        $is_student = $is_student_query->count();
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);       
        }
        
        $list['data'] =  DocOtherResource::collection(\App\Model\Api\DocOther::where('user_id',decode($input['studentID']))->where('application_id',  decode($input['applicationID']))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    function message_errors(){
        return [
        ];
    }
    
}
