<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\CustomField;
use App\Model\Api\CustomFieldModule;
use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\CustomFieldResource as CustomFieldResource;

class CustomFieldController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){
        $this->common=new CommonController();
    }

    function create(Request $request){

        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'type' => 'required',
        ],  $this->message_errors());

        if(Auth::user()->role != 2){
            return response()->json(['error'=>"Invalid access"], 401);
        }
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        $input = $request->all();
        $input['administer_id'] =  ownerKeyId( secret_key_get() );
        $data = new CustomField($input);
        if($data->save()){
            return response()->json(['success'=>"Custom field has been created successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    function update(Request $request,$id){
        $id = decode($id);
        $validator = Validator::make($request->all(), [
            //'name' => 'required',
            'status' =>'required',
        ],  $this->message_errors());

        if(Auth::user()->role != 2){
            return response()->json(['error'=>"Invalid access"], 401);
        }

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        
        $input = $request->all();
        $data = CustomField::find($id);
        if($data->update($input)){
            return response()->json(['success'=>"Application Status has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    public function single($id=0){
        $id = decode($id);
        $list['data'] =  CustomFieldResource::collection(CustomField::where('administer_id', ownerKeyId( secret_key_get() ))->where('id',$id)->where('status',1)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    public function show(Request $request){
        $list['data'] =  CustomFieldResource::collection(CustomField::where('administer_id', ownerKeyId( secret_key_get() ))->where('status',1)->orderBy('id', 'asc')->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function show_filter(Request $request){
        
        if(count($request->all())){
            if($request->input('status')){
                $query = CustomField::where('administer_id', ownerKeyId( secret_key_get() ))->where('id',$request->input('status'))->orderBy('id', 'asc');
            }else{
                $query = CustomField::where('administer_id', ownerKeyId( secret_key_get() ))->orderBy('id', 'asc');
            }
            
        }else{
            $query = CustomField::where('administer_id', ownerKeyId( secret_key_get() ))->orderBy('id', 'asc');
        }
        $list['data'] =  CustomFieldResource::collection($query->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    function save_module(Request $request){
        $validator = Validator::make($request->all(), [
            'module' => 'required',
        ],  $this->message_errors());

        $input = $request->all();
        if($input['module'] == 'application') {
            $is_save = CustomFieldModule::updateOrCreate(
                ['administer_id' => ownerKeyId( secret_key_get() )],
                ['application_fields' => $input['field_ids']]
            );
        } else if($input['module'] == 'client') {
            $is_save = CustomFieldModule::updateOrCreate(
                ['administer_id' => ownerKeyId( secret_key_get() )],
                ['client_fields' => $input['field_ids']]
            );
        } else if($input['module'] == 'lead') {
            $is_save = CustomFieldModule::updateOrCreate(
                ['administer_id' => ownerKeyId( secret_key_get() )],
                ['lead_fields' => $input['field_ids']]
            );
        } else if($input['module'] == 'interaction') {
            $is_save = CustomFieldModule::updateOrCreate(
                ['administer_id' => ownerKeyId( secret_key_get() )],
                ['interaction_fields' => $input['field_ids']]
            );
        }
        if($is_save){
            return response()->json(['success'=>"Custom field has been created successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }


    function get_module(Request $request){
        $is_save = CustomFieldModule::where('administer_id', ownerKeyId( secret_key_get() ))->first();
        if($is_save){
            return response()->json($is_save, $this->successStatus);
        }else{
            return response()->json(NULL, $this->successStatus);
        }
    }
    
    function message_errors(){
        return [
            'name'=>'Name is required',
            'type'=>'Type is required',
            'module'=>'Module is required',
        ];
    }

}
