<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use Auth;
use App\User;
use App\Http\Controllers\CommonController;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Session;
use App\Model\Notes;


class UserController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    protected $common;
    public function __construct(){     
        $this->middleware('auth');
        $this->common=new CommonController();
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */   
    
    public function show(){
        
        $content['pageConfigs'] = ['pageHeader' => true];
        $content['breadcrumbs'] = [
          ["link" => route('admin.home'), "name" => "Home"],["name" => "Customers"]
        ];
        
        
        return view('admin.user.list');
    }
    public function edit($id){
      $content['r']=  User::find($id);
      $content['order']= \App\Model\Orders::where('user_id',$id)->get();    
      $content['notes'] = Notes::where('user_id',$id)->orderBy('created_at', 'desc')->get(); 
      
      $content['pageConfigs'] = ['pageHeader' => true];
       $content['breadcrumbs'] = [
          ["link" => route('admin.home'), "name" => "Home"],[ "link" => route('admin.user.manage'),"name" => "Customers"],["name" => "Profile"]
        ];
      return view('admin.user.edit',$content);  
    }
   
    public function update(Request $request,$id){
        $data=User::find($id);
        if($request->has('status')){
            $data->status=$request->input('status');
            if($request->input('note') !=""){
                $notes_data['notes'] = $request->input('note');
                $notes_data['user_id'] = $id;
                $notes = new Notes($notes_data);
                $notes->save();

            }
        }
        if($request->has('api_status')){
            $data->api_status=$request->input('api_status');
        }
        
        if($data->save()){
            if($request->has('api_status')){
                $api_status = "Resume";
                if($request->input('api_status') == "0"){
                    $api_status = "Stop";
                }
                /*Notification*/
                $notifi['to_id'] = $id;
                $notifi['from_id'] = Auth::id();
                $notifi['type'] ='admin_to_customer';
                $notifi['message'] = 'Your current subscription '.$api_status.' by admin. Contact to admin.';
                $notification = new \App\Model\Notification($notifi);
                $notification->save();
                
                
                $email['heading'] ='Subscription has been '.$api_status.' by admin.';
                $email['content'][] = "Your subscription has been ".$api_status." by admin.So please contact to admin.";
                $view = View('emailtemplates.notification',$email); 
                $content =$view->render();
                $user = User::find($id);
                $this->common->sendSMTPSystem($user->email, "Subscription ".$api_status,$content);
                
            }
            
            if($request->has('status')){
                
                $status = "Active";
                if($request->input('status') == "0"){
                    $status = "De-Active";
                }
                
                $email['heading'] ='Account has been '.$status.' by admin.';
                $email['content'][] = "Your Account has been ".$status." by admin.So please contact to admin.";
                $view = View('emailtemplates.notification',$email); 
                $content =$view->render();
                $user = User::find($id);
                $this->common->sendSMTPSystem($user->email, "Account stop",$content);
            }
            $request->session()->flash('success', 'Status/Notes updated successfully!');
            return redirect()->back();
        }else{
            $request->session()->flash('error', 'Error!');
            return redirect()->back();
        }
    }
    
    function showList(){        
        $record = User::where("role", '=', "2")->where('email_verified_at','!=',null)->orderBy('id', 'desc');    
        if(Input::get('filterextend')!==false){
            if(Input::get('filterextend')!=""){
                $record->where("status",Input::get('filterextend'));
            }
        }
        
        return Datatables::of($record) 
           
           ->editColumn('status',function($record) {
              if($record->status==0){                    
                   return "<span class='label label-danger'>In-Active</span>";                   
               }else{
                   return "<span class='label label-success'>Active</span>";
               }               
            })
            ->editColumn('subscribe_date',function($record) {
               $subscribe =  get_active_subscription($record->id);
               if(!empty($subscribe)){
                   $service= "<span class='label label-success'>Subscribed - ".$subscribe->name."</span> ";
                   if($record->api_status){
                       $service.="<br><span class='label label-success'>API Service Active</span>";
                   }else{
                       $service.="<br><span class='label label-danger'>API Service Stop</span>";
                   }
                   return $service;
               }else{
                   return "<span class='label label-danger'>Not Subscribe</span>";    
               }          
            })
            
            ->addColumn('actions',function($record) {
                $actions = '<a href="'. route('admin.user.editForm',$record->id).'" class="on-default"><i class="fa fa-user-o"></i></a> &nbsp;';
                
                return $actions;
            })
            ->rawColumns(['actions','status','subscribe_date'])
            ->make(true);            
    }   
    
   
    
    function key_generate($id=0){
        $data=User::find($id);
        $record = User::where('id',$id)->first();
        $oldSecret = $record->secret_key;
       
        $encrypted = md5(encrypt($id));
        $data->secret_key=$encrypted;
        
        if($data->save()){
            
            if($oldSecret !=""){
                $this->common->keyUpdateAll($oldSecret,$encrypted);
            }
            
            Session::flash('success', 'Key has been generated successfully!');
            return redirect(route('admin.user.editForm',$id));
        }else{
            Session::flash('error', 'Error!');
            return redirect(route('admin.user.editForm',$id));
        }
        
    }
    
    function export(){
        $users = User::where("role", '=', "2")->where('email_verified_at','!=',null)->orderBy('id', 'desc')->get();
        $cnt=0;
        foreach($users as $user) {
            $rows[$cnt][] = $user->name.' '.$user->last_name;
            $rows[$cnt][] = $user->phone;
            $rows[$cnt][] = $user->email;
            $rows[$cnt][] = $user->subscribe_date;
            $rows[$cnt][] = $user->address.' '.$user->city.', '.$user->state.', '.$user->country.' - '.$user->zipcode;
            $cnt++;
        }
        $columnNames = ['Name', 'Phone','Email','SubscriptioEndDate','Address'];//replace this with your own array of string column headers        
        return self::getCsv($columnNames, $rows,'customer.csv');
    }
    
    public static function getCsv($columnNames, $rows, $fileName = 'file.csv') {
        $headers = [
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=" . $fileName,
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        ];
        $callback = function() use ($columnNames, $rows ) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columnNames);
            foreach ($rows as $row) {
                fputcsv($file, $row);
            }
            fclose($file);
        };
        return response()->stream($callback, 200, $headers);
    }
    
    
    
    /*Subscriptions Cancel*/
    function cancelSubscription(Request $request, $package='',$user_id=0){
        if($this->common->is_subscribe($package,$user_id)){
            $this->common->cancelSubscription($package,$user_id);
            
            
            /*Notification*/
            $notifi['to_id'] = $user_id;
            $notifi['from_id'] = Auth::id();
            $notifi['type'] ='admin_to_customer';
            $notifi['message'] = 'Subscription cancelled by admin';
            $notification = new \App\Model\Notification($notifi);
            $notification->save();
            
            
            $email['heading'] ='Subscription has been cancelled by admin.';
            $email['content'][] = "Your subscription has been cancelled by admin.So please contact to admin.";
            $view = View('emailtemplates.notification',$email); 
            $content =$view->render();
            $user = User::find($user_id);
            $this->common->sendSMTPSystem($user->email, "Subscription cancelled",$content);
            
            $request->session()->flash('success', 'Your susbscription will be cancel at the end of the subscription date.');
            return redirect()->back();
        }
    }
    function cancelSubscriptionNow(Request $request, $package='',$user_id=0){
        if($this->common->is_subscribe($package,$user_id)){
            $this->common->cancelSubscriptionNow($package,$user_id);
            
            /*Notification*/
            $notifi['to_id'] = $user_id;
            $notifi['from_id'] = Auth::id();
            $notifi['type'] ='admin_to_customer';
            $notifi['message'] = 'Subscription cancelled (immediate) by admin';
            $notification = new \App\Model\Notification($notifi);
            $notification->save();
            
            $email['heading'] ='Subscription has been cancelled by admin.';
            $email['content'][] = "Your subscription has been cancelled by admin.So please contact to admin.";
            $view = View('emailtemplates.notification',$email); 
            $content =$view->render();
            $user = User::find($user_id);
            $this->common->sendSMTPSystem($user->email, "Subscription cancelled",$content);
            
            
            $request->session()->flash('success', 'Your susbscription has been cancelled.');
            return redirect()->back();
        }
    }
    
    function stopSubscriptionNow(Request $request,$user_id=0){
        $user = User::find($user_id);
        $user->api_status = 0;
        if($user->save()){
            $request->session()->flash('success', 'Your susbscription has been cancelled.');
            return redirect()->back();
        }else{
            $request->session()->flash('error', 'Something went wrong. Please try after some time.');
            return redirect()->back();
        }
    }
}
