<?php

namespace App\Model\Api;
use Illuminate\Database\Eloquent\Model;

class DocumentsAssign extends Model{
  
   
   protected $table="documents_assign";
   protected $fillable=[
       'docID','assignedByAdmin','assignedByAgent','studentID','docCustomer'
   ]; 
   
   function user(){
     return $this->belongsTo('App\User','studentID','id');
   } 
   function assigner(){
     return $this->belongsTo('App\User','assignedByAgent','id');
   } 
   function assignerAdmin(){
     return $this->belongsTo('App\User','assignedByAdmin','id');
   } 
   
   function doc(){
     return $this->belongsTo('App\Model\Api\Documents','docID','id');
   }
   
}
