<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class Task extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
           
            'id' => encode($this->id),
            $this->mergeWhen(Auth::user()->isCompany(), [
                'assignTo' => $this->user->name .' '.$this->user->last_name,
            ]),
            $this->mergeWhen(Auth::user()->isManager(), [
                'assignTo' => $this->user->name .' '.$this->user->last_name,
            ]),
            
            'assignToID' => encode($this->assignTo),
            'title' => $this->title,
            'description'=>  $this->description,
            'status'=>  $this->status,
            'notes'=>  $this->notes,
            'endDate'=>  $this->endDate,
            
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
