<?php

namespace App\Http\Controllers\Api\Invoice;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Invoice\Settings;

use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\InvoiceSettings as InvoiceSettingsResource;




class SettingsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){  
        $this->common=new CommonController();
    }

    
    
    function save(Request $request){
        
       
        $validator = Validator::make($request->all(), [
            'service' =>'required',
        ],  $this->message_errors());
        
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }

        
        
        $input = $request->all();

        if($request->input('is_deleted')) {
            if($request->input('is_deleted') == 'yes') {
                $input['companyLogo'] = null;
            }
            unset($input['is_deleted']);
        }

        
        
        if($request->hasFile('companyLogo')){
           $input['companyLogo'] = $this->common->fileUpload($request->file('companyLogo'),'uploads/invoicelogo/');
        }
        
        $administer_id =  ownerKeyId(secret_key_get());
        if($this->is_exist()){
           $data = Settings::where('administer_id',$administer_id);
           if($data->update($input)){
                return response()->json(['success'=>"Settings has been updated successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
        }else{
            $input['administer_id'] =  ownerKeyId(secret_key_get());
            $data = new Settings($input);
            if($data->save()){
                return response()->json(['success'=>"Settings has been created successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
        }
       
    }
    public function show(){
        $admin_id = ownerKeyId(secret_key_get());
        $result = Settings::where('administer_id',$admin_id)->get();
        $list['data'] =  InvoiceSettingsResource::collection($result);
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    
    function is_exist($id=0){
        $admin_id = ownerKeyId(secret_key_get());
        return Settings::where('administer_id',$admin_id)->count();
    }
    
    function message_errors(){
        return [
            'service'=>'Service value required',
            'taxrate'=>'Tax rate required',
        ];
    }
    
}
