<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Applicationservice;

use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;

use App\Http\Resources\Applicationservice as ApplicationserviceResource;




class ApplicationServiceController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){
        $this->common=new CommonController();
    }

    function create(Request $request){

        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'short' =>'required',
        ],  $this->message_errors());

        if(Auth::user()->role != 2){
            return response()->json(['error'=>"Invalid access"], 401);
        }

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        $input = $request->all();
        $input['administer_id'] =  ownerKeyId( secret_key_get() );
        $input['position'] = 0;
        $data = new Applicationservice($input);
        if($data->save()){
            return response()->json(['success'=>"Application service has been created successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    function update(Request $request,$id){
        $id = decode($id);
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'short' =>'required',
            'status' =>'required',
        ],  $this->message_errors());

        if(Auth::user()->role != 2){
            return response()->json(['error'=>"Invalid access"], 401);
        }

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        
        $input['status'] = $request->input('status');
        $input['name'] = $request->input('name');
        $input['short'] = $request->input('short');
        $data = Applicationservice::find($id);
        if($data->update($input)){
            return response()->json(['success'=>"Application service has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    public function single($id=0){
        $id = decode($id);
        $list['data'] =  ApplicationserviceResource::collection(Applicationservice::where('administer_id', ownerKeyId( secret_key_get() ))->where('id',$id)->where('status',1)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    public function show(Request $request){
        $list['data'] =  ApplicationserviceResource::collection(Applicationservice::where('administer_id', ownerKeyId( secret_key_get() ))->where('status',1)->orderBy('position', 'asc')->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function show_filter(Request $request){
        
        if(count($request->all())){
            if($request->input('status')){
                $query = Applicationservice::where('administer_id', ownerKeyId( secret_key_get() ))->where('status',$request->input('status'))->orderBy('name', 'asc');
            }else{
                $query = Applicationservice::where('administer_id', ownerKeyId( secret_key_get() ))->orderBy('name', 'asc');
            }
            
        }else{
            $query = Applicationservice::where('administer_id', ownerKeyId( secret_key_get() ))->orderBy('name', 'asc');
        }
        $list['data'] =  ApplicationserviceResource::collection($query->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    
    function message_errors(){
        return [
            'name'=>'Service name required',
            'short'=>'Short name required',
            'status'=>'Status required',
        ];
    }

}
