<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use Auth;
use App\Model\Package;


class PackageController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    protected $common;
    public function __construct(){     
        $this->middleware('admin.permissions');
        $this->common=new CommonController();
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */   
    public function create(){   
        $content['pageConfigs'] = ['pageHeader' => true];
        $content['breadcrumbs'] = [
          ["link" => route('admin.home'), "name" => "Home"],["link" => route('admin.package.manage'), "name" => "Package - Manage"],["name" => "Add New"]
        ];
        $content['package'] = Package::get();
        return view('admin.package.create',$content);
    }
    public function show(){
//        $info = Package::where('id','2')->first();
//        echo "<pre>"; print_r(json_encode($info)); echo "</pre>"; die();
        $content['pageConfigs'] = ['pageHeader' => true];
        $content['breadcrumbs'] = [
          ["link" => route('admin.home'), "name" => "Home"],["name" => "Package"]
        ];
        return view('admin.package.list',$content);
    }
    public function edit($id){
        $content['breadcrumbs'] = [
          ["link" => route('admin.home'), "name" => "Home"],["link" => route('admin.package.manage'), "name" => "Package - Manage"],["name" => "Edit"]
        ];
      $content['r']=  Package::find($id);
      return view('admin.package.edit',$content);  
    }
    public function view($id){
        $content['breadcrumbs'] = [
          ["link" => route('admin.home'), "name" => "Home"],["link" => route('admin.package.manage'), "name" => "Package - Manage"],["name" => "View"]
        ];
      $content['r']=  Package::find($id);
      return view('admin.package.view',$content);  
    }
    
    public function store(Request $request){
        
        $request->validate([
            'name' => 'required',
            'duration' => 'required',
            'price' => 'required', 
            'stripe_id' =>'required'
        ]);        
        $form_data = $request->all();
        $data = new Package($form_data);       
        if($data->save()){
            $request->session()->flash('success', 'Package created successfully!');
            return redirect(route('admin.package.create'));
        }else{
            $request->session()->flash('error', 'Error!');
            return redirect(route('admin.package.create'));
        }
    }  
    public function update(Request $request,$id){
        $request->validate([
            'name' => 'required',
            'duration' => 'required',
            'price' => 'required', 
            'stripe_id' =>'required'
        ]); 
        $form_data = $request->all();
        
        $data = Package::find($id);  
        
        if($data->update($form_data)){
            $request->session()->flash('success', 'Package updated successfully!');
            return redirect(route('admin.package.manage'));
        }else{
            $request->session()->flash('error', 'Error!');
            return redirect(route('admin.package.manage'));
        }
    }
    
    function showList(){        
        $record = Package::query();        
        return Datatables::of($record) 
           ->editColumn('status',function($record) {
               if($record->status){
                  return "<span class='label label-success'>Active</span>";
               }else{
                   return "<span class='label label-danger'>De-Active</span>";
               }
               
            })     
            ->addColumn('actions',function($record) {
                $actions = '<a href="'. route('admin.package.editForm',$record->id).'" class="on-default"><i class="fa fa-pencil"></i></a> &nbsp;';
                if($record->id !=3){
                    $actions.= '<a href="javascript:void(0);" data-url="'. route('admin.package.deleteAjax',$record->id).'" class="on-default sa-warning"><i class="fa fa-trash"></i></a> &nbsp;';
                }
                $actions.= '<a href="'. route('admin.package.view',$record->id).'" class="on-default"><i class="fa fa-laptop"></i></a> &nbsp;';
                return $actions;
            })
            ->rawColumns(['actions','status'])
            ->make(true);            
    }   
    
    function delete($id){
        
        echo Package::where("id",$id)->delete();
        die();
    }
    
}
