<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect(route('login'));
});

Auth::routes(['verify' => true]);
//Route::get('test',['as'=>"login",'uses'=>"Auth\LoginController@test"]);
Route::get('login',['as'=>"login",'uses'=>"Auth\LoginController@loginform"]);
Route::post('login',['as'=>"login",'uses'=>"Auth\LoginController@login"]);

//Route::get('email/verify', 'Auth\VerificationController@show')->name('verification.notice');
//Route::get('email/verify/{id}', 'Auth\VerificationController@verify')->name('verification.verify');


Route::get('email/verify/{id}', 'Auth\VerificationController@verifyUser')->name('verification.verify');

Route::get('home', function () {
    return redirect(route('login'));
})->name('home');
Route::group(['prefix' => 'admin', 'as' => 'admin.','middleware'=>['auth','admin.permissions']], function () {
    Route::get('home', ['as'=>'home', 'uses'=>'Admin\HomeController@index']);
    Route::get('my-porfile', ['as'=>'profile', 'uses'=>'Admin\HomeController@profile']);
    Route::get('porfile-edit', ['as'=>'profile_edit', 'uses'=>'Admin\HomeController@profile_edit']);
    Route::post('porfile-update', ['as'=>'profile_update', 'uses'=>'Admin\HomeController@profile_update']);
    
    
    
    Route::group(['prefix'=>'customer','as'=>'user.','middleware'=>['auth','admin.permissions']],function(){
        Route::get('manage',['as'=>'manage','uses'=>'Admin\UserController@show']);
        Route::get('getAjaxList',['as'=>'showAjaxList','uses'=>'Admin\UserController@showList']);
        Route::get('profile-user/{id}',['as'=>'editForm','uses'=>'Admin\UserController@edit']);
        Route::post('edit/{id}',['as'=>'edit_update','uses'=>'Admin\UserController@update']);
        Route::get('deleteAjax/{id}',['as'=>'deleteAjax','uses'=>'Admin\UserController@delete']);
        Route::get('changeStatus/{id}/{val}',['as'=>'changestatus','uses'=>'Admin\UserController@statusUpdate']);
        
        /*Key Generate*/
        Route::get('key-generate/{id}',['as'=>'key_generate','uses'=>'Admin\UserController@key_generate']);
        
        Route::get('export',['as'=>'export','uses'=>'Admin\UserController@export']);
        
    });
    
    /*Subscription*/
    Route::group(['prefix'=>'subscription-package','as'=>'package.','middleware'=>['auth','admin.permissions']],function(){
        Route::get('add-new',['as'=>'add_new','uses'=>'Admin\PackageController@create']);
        Route::post('add-new',['as'=>'create','uses'=>'Admin\PackageController@store']);
        Route::get('manage',['as'=>'manage','uses'=>'Admin\PackageController@show']);
        Route::get('getAjaxList',['as'=>'showAjaxList','uses'=>'Admin\PackageController@showList']);
        Route::get('edit/{id}',['as'=>'editForm','uses'=>'Admin\PackageController@edit']);
        Route::post('edit/{id}',['as'=>'edit_update','uses'=>'Admin\PackageController@update']);
        Route::get('deleteAjax/{id}',['as'=>'deleteAjax','uses'=>'Admin\PackageController@delete']);
        Route::get('view/{id}',['as'=>'view','uses'=>'Admin\PackageController@view']);
        
    });
    
   
    Route::group(['prefix'=>'orders','as'=>'order.','middleware'=>['auth','admin.permissions']],function(){
        Route::get('manage',['as'=>'manage','uses'=>'Admin\OrdersController@show']);
        Route::get('getAjaxList',['as'=>'showAjaxList','uses'=>'Admin\OrdersController@showList']);
        Route::get('order-view/{id}',['as'=>'view','uses'=>'Admin\OrdersController@view']);
        Route::post('edit/{id}',['as'=>'edit_update','uses'=>'Admin\OrdersController@update']);
        Route::get('export',['as'=>'export','uses'=>'Admin\OrdersController@export']);
    });
    
    /*Notification*/
    Route::group(['prefix' => 'notification', 'as' => 'notification.','middleware'=>['auth','admin.permissions']], function () {
    
        Route::get('add-new',['as'=>'add_new','uses'=>'NotificationController@create']);
        Route::post('add-new',['as'=>'create','uses'=>'NotificationController@store']);
        Route::get('manage',['as'=>'manage','uses'=>'NotificationController@show']);
        Route::get('getAjaxList',['as'=>'showAjaxList','uses'=>'NotificationController@showList']);
        Route::get('edit/{id}',['as'=>'editForm','uses'=>'NotificationController@edit']);
        Route::post('edit/{id}',['as'=>'edit_update','uses'=>'NotificationController@update']);
        Route::get('deleteAjax/{id}',['as'=>'deleteAjax','uses'=>'NotificationController@delete']);


    });
    
    Route::get('cancel-subscription/{package_name}/{userid}',['as'=>'subscription_cancel','uses'=>'Admin\UserController@cancelSubscription']);
    Route::get('cancel-subscription-now/{package_name}/{userid}',['as'=>'subscription_cancel_now','uses'=>'Admin\UserController@cancelSubscriptionNow']);
    Route::get('stop-subscription-now/{userid}',['as'=>'subscription_stop_now','uses'=>'Admin\UserController@stopSubscriptionNow']);
    
    
});

/*Authorized*/
Route::group(['prefix' => 'notification', 'as' => 'notification.','middleware'=>['auth']], function () {
    Route::get('manage',['as'=>'manage','uses'=>'NotificationController@show_user']);
    Route::get('getAjaxList',['as'=>'showAjaxList','uses'=>'NotificationController@showList_user']);
    Route::get('view/{id}',['as'=>'view','uses'=>'NotificationController@view']);
    
    
});
Route::get('invoice/{id}',['as'=>'invoice_view','uses'=>'HomeController@invoice','middleware'=>['auth']]);

Route::group(['prefix' => 'customer', 'as' => 'customer.','middleware'=>['auth','company.permissions','verified']], function () {
    Route::get('home', ['as'=>'home', 'uses'=>'Customer\HomeController@profile']);
    Route::get('my-porfile', ['as'=>'profile', 'uses'=>'Customer\HomeController@profile']);
    Route::get('porfile-edit', ['as'=>'profile_edit', 'uses'=>'Customer\HomeController@profile_edit']);
    Route::post('porfile-update', ['as'=>'profile_update', 'uses'=>'Customer\HomeController@profile_update']);
    Route::get('secret-key', ['as'=>'secret_key', 'uses'=>'Customer\HomeController@secret_key']);
    
    Route::get('key-generate',['as'=>'key_generate','uses'=>'Customer\HomeController@key_generate']);
    
    Route::group(['prefix'=>'orders','as'=>'order.','middleware'=>['auth','company.permissions']],function(){
        Route::get('manage',['as'=>'manage','uses'=>'Customer\OrdersController@show']);
        Route::get('getAjaxList',['as'=>'showAjaxList','uses'=>'Customer\OrdersController@showList']);
        Route::get('order-view/{id}',['as'=>'view','uses'=>'Customer\OrdersController@view']);
    });
    Route::get('packages',['as'=>'packages','uses'=>'Customer\HomeController@packages']);
    Route::group(['prefix'=>'payment','as'=>'payment.','middleware'=>['auth','company.permissions']],function(){
        Route::get('subscription/{package_id}',['as'=>'subscription','uses'=>'Customer\PaymentController@show']);
        Route::post('subscription/{package_id}', ['as'=>'post-subscription','uses'=>'Customer\PaymentController@postSubscription']);
        
        Route::get('update-card',['as'=>'update_card','uses'=>'Customer\PaymentController@update_card']);
        Route::post('update-card-save', ['as'=>'update_card_save','uses'=>'Customer\PaymentController@update_card_save']);
        
        Route::get('setup-cost',['as'=>'setup_cost_show','uses'=>'Customer\PaymentController@setup_cost_show']);
        Route::post('setup-cost', ['as'=>'setup_cost_save','uses'=>'Customer\PaymentController@setupFeecharge']);
        
        
    });
    Route::get('cancel-subscription/{package_name}',['as'=>'subscription_cancel','uses'=>'Customer\PaymentController@cancelSubscription']);
    Route::get('cancel-subscription-now/{package_name}',['as'=>'subscription_cancel_now','uses'=>'Customer\PaymentController@cancelSubscriptionNow']);
    
});


/*Ajax*/
Route::group(['prefix' => 'ajax', 'as' => 'ajax.','middleware'=>['auth']], function () {
    Route::post('checkUserExist',['as'=>'checkUserExist','uses'=>'AjaxController@checkUserExist']); 
    Route::post('checkUserExists',['as'=>'checkUserExistID','uses'=>'AjaxController@checkUserExistByID']);
});


Route::post('stripe/webhook',['uses'=>'WebhookController@handleWebhook']); 