@extends('layouts.default')
@section('title','Invoice')
@section('header_extra')

@stop
@section('content')
 <div class="row">
    <div class="col-12">
        <div class="card-box">
            
            <div class="clearfix">
                <div class="pull-left">
                    <img src="{{asset('assets/images/logo_dark.png')}}" alt="" height="30">
                </div>
                <div class="pull-right">
                    <h3 class="m-0 hidden-print">Invoice - {{$r->id}}</h3>
                </div>
            </div>


            <div class="row">
                <div class="col-6">
                    <div class="pull-left m-t-30">
                        <?php 
                            $product = json_decode($r->product_information);
                        
                        ?>
                        <p><b>Hello</b></p>
                        <p class="text-muted">Thanks a lot because you keep purchasing our products. Our company
                            promises to provide high quality products for you as well as outstanding
                            customer service for every transaction. </p>
                    </div>

                </div><!-- end col -->
                <div class="col-4 offset-2">
                    <div class="m-t-30 pull-right">
                        <p class="m-b-10"><small><strong>Invoice Date: </strong></small> {{date('M d, Y',strtotime($r->created_at))}}</p>
                        <p class="m-b-10"><small><strong>Invoice Status: </strong></small> {!! invoice_status($r->status) !!}</p>
                        <p class="m-b-10"><small><strong>Order ID: </strong></small> #{{$r->order_id}}</p>
                    </div>
                </div><!-- end col -->
            </div>
            <!-- end row -->

            <div class="row m-t-30">
                <div class="col-6">
                    <h5>From</h5>

                    <address class="line-h-24">
                        Aerocodex<br>
                        Montreal, Canada<br>
                        <abbr title="Phone">P:</abbr> 438-402-4475
                    </address>

                </div>

                <div class="col-6">
                    <h5>To</h5>

                    <address class="line-h-24">
                       {!! $r->customer_information !!}
                    </address>

                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table m-t-30">
                            <thead>
                            <tr>
                                <th>Service</th>
                                <th>Product</th>
                                <th class="text-right">Price</th>
                            </tr></thead>
                            <tbody>
                            <tr>
                                <td>@if($product->type == 1) <b>Subscription</b> @else <b>Setup Cost</b> @endif</td>
                                <td>
                                    <b>{{$product->name}}</b> <br>
                                    @if($product->type == 1)
                                    Duration: {{$product->duration}}
                                    @else
                                    One time cost
                                    @endif
                                </td>
                                <td class="text-right">{{$r->price}}</td>
                            </tr>
                            
                           
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-6">
                    <div class="clearfix p-t-50">
                        <h5 class="text-muted">Notes:</h5>

                        <small>
                            All accounts are to be paid within 7 days from receipt of
                            invoice. To be paid by cheque or credit card or direct payment
                            online. If account is not paid within 7 days the credits details
                            supplied as confirmation of work undertaken will be charged the
                            agreed quoted fee noted above.
                        </small>
                    </div>

                </div>
                <div class="col-6">
                    <div class="float-right">
                        <p><b>Sub-total:</b> ${{$r->price}}</p>
                        <p><b>Tax({{$r->tax_rate}}%):</b> ${{$r->tax}}</p>
                        <h3>${{$r->grand_total}} CAD</h3>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>

            <div class="hidden-print m-t-30 m-b-30">
                <div class="text-right">
                    <a href="javascript:window.print()" class="btn btn-primary waves-effect waves-light"><i class="fa fa-print m-r-5"></i> Print</a>
                    <a href="javascript:void(0)" onclick="history.back()" class="btn btn-info waves-effect waves-light">Back</a>
                </div>
            </div>
                                
            
        </div>
    </div>
 </div>
@stop


@section('footer_scripts')


<script type="text/javascript">
    $(document).ready(function() {
    });
</script>
@stop

