@extends('layouts.default')
@section('title','My Profile')
@section('header_extra')
@stop

@section('content')
<div class="row">
    <div class="col-sm-12">
        <div class="profile-bg-picture">
            <span class="picture-bg-overlay"></span><!-- overlay -->
        </div>
        <!-- meta -->
        <div class="profile-user-box">
            <div class="row">
                
                
                
                <div class="col-sm-4">
                    <span class="pull-left m-r-15">
                        @if($r->picture!="")
                        <img src="{{asset('uploads/profile/'.$r->picture)}}" alt="" class="thumb-lg rounded-circle">
                        @endif
                    </span>
                    <div class="media-body">
                        <h4 class="m-t-5 m-b-5 font-18 ellipsis">{{$r->name.' '.$r->last_name}}</h4>
                        <p class="font-13"> {{$r->company_name}}</p>
                        <p class="text-muted m-b-0"><small>{{$r->state. ' '.$r->country}}</small></p>
                    </div>
                </div>
                
                <div class="col-sm-8">
                    <div class="text-right">
                        <a href="{{route('customer.profile_edit')}}" class="btn btn-success waves-effect waves-light">
                            <i class="mdi mdi-account-settings-variant m-r-5"></i> Edit Profile
                        </a>
                    </div>
                    
                    <?php $active_subscription =  get_active_subscription(); ?>
                    @if(!empty($active_subscription))
                    <div class="text-right">
                        <h2>Subscribed</h2>
                        <h4>  
                            <span class="label label-success">{{$active_subscription->name}} - {{package_information($active_subscription->stripe_plan,'duration')}}</span>
                        </h4>
                    </div>
                    @else
                    <div class="text-right">
                        <h4><a href="{{route('customer.packages')}}" class="btn btn-danger">Subscribe Now</a></h4>
                    </div>
                    @endif
                </div>
                <div class="m-t-15 col-12">
                    @include('widget/notifications')
                </div>
                
            </div>
        </div>
        <!--/ meta -->
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <!-- Personal-Information -->
        <div class="card-box">
            <h4 class="header-title mt-0 m-b-20">Personal Information</h4>
            <div class="panel-body">
                <div class="text-left">
                    <p class="text-muted font-13"><strong>Full Name :</strong> <span class="m-l-15">{{$r->name.' '.$r->last_name}}</span></p>

                    <p class="text-muted font-13"><strong>Mobile :</strong><span class="m-l-15">{{$r->phone}}</span></p>

                    <p class="text-muted font-13"><strong>Email :</strong> <span class="m-l-15">{{$r->email}}</span></p>

                    <p class="text-muted font-13"><strong>Address :</strong> <span class="m-l-15">{{$r->address}}</span></p>
                    
                    
                    <p class="text-muted font-13"><strong>Company Name :</strong> <span class="m-l-15">{{$r->company_name}}</span></p>
                    <p class="text-muted font-13"><strong>Web Site :</strong> <span class="m-l-15">{{$r->website}}</span></p>
                    <p class="text-muted font-13"><strong>Company Name :</strong> <span class="m-l-15">{{$r->company_name}}</span></p>
                    <p class="text-muted font-13"><strong>Company Email :</strong> <span class="m-l-15">{{$r->company_email}}</span></p>
                    <p class="text-muted font-13"><strong>Company Phone Number :</strong> <span class="m-l-15">{{$r->company_phone}}</span></p>
                    <p class="text-muted font-13"><strong>Number of employee :</strong> <span class="m-l-15">{{$r->number_employee}}</span></p>
                    <p class="text-muted font-13"><strong>Privacy Policy Link :</strong> <span class="m-l-15"> <a href="{{$r->privacy_policy_link}}">{{$r->privacy_policy_link}}</a> </span></p>
                    
                    
                    <p class="text-muted font-13"><strong>City :</strong> <span class="m-l-15">{{$r->city}}</span></p>
                    <p class="text-muted font-13"><strong>Province :</strong> <span class="m-l-15">{{$r->state}}</span></p>
                    <p class="text-muted font-13"><strong>Country :</strong> <span class="m-l-15">{{$r->country}}</span></p>
                    <p class="text-muted font-13"><strong>Postal :</strong> <span class="m-l-15">{{$r->zipcode}}</span></p>
                    <p class="text-muted font-13"><strong>Status :</strong> 
                        <span class="m-l-15">
                            @if($r->status == "1")
                            <span class="label label-success">Active</span>
                            @elseif($r->status == "0")
                            <span class="label label-danger">Disable</span>
                            @endif
                            
                        </span>
                    </p>
                </div>
            </div>
        </div>
        <!-- Personal-Information -->

        

    </div>
    @if(!empty($active_subscription))
    <div class="col-md-6">
        <div class="card-box">
            <h4 class="header-title mt-0 m-b-20">Subscription Information</h4>
            @if($r->api_status == 0 )
            <h4 class="header-title m-t-1 m-b-20"><span class="label label-danger">Your API Service is Stop. Please contact to Admin for resume service.</span></h4>
            @endif
           
            <div class="panel-body">
                <div class="text-left">
                    <?php $pack =  package_information($active_subscription->stripe_plan,''); ?>
                    <p class="text-muted font-13"><strong>Active Date :</strong> <span class="m-l-15">{{date('M-d Y h:i a',strtotime($active_subscription->created_at))}}</span></p>
                    <p class="text-muted font-13"><strong>Package Name :</strong> <span class="m-l-15">{{$pack->name}}</span></p>
                    <p class="text-muted font-13"><strong>Duration :</strong> <span class="m-l-15">{{$pack->duration}}</span></p>
                    <p class="text-muted font-13"><strong>Price :</strong> <span class="m-l-15">{{$pack->price}}</span></p>
                    @if($active_subscription->ends_at!="")
                    <h4 class="header-title m-t-1 m-b-20">
                        <span class="label label-danger"> Subscription will be cancel at {{date('M-d Y h:i a',strtotime($active_subscription->ends_at))}}</span>
                 
                    </h4>
                    @endif
                    <div class="row">
                        <div class="col-md-12 mx-auto">
                            <div class="row">
                                @if($active_subscription->ends_at=="")
                                <div class="col-md-5">
                                    <a href="javascript:void(0);" onclick="confirm_cancel('<?=$pack->name?>')" class="btn btn-danger">Cancel Subscription</a>
                                </div>
                                @endif
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card-box">
            <h4 class="header-title mt-0 m-b-20">Card Information</h4>
            <div class="panel-body">
                <div class="text-left">
                    <p class="text-muted font-13"><strong>Card Type :</strong> <span class="m-l-15">{{strtoupper($r->card_brand)}}</span></p>
                    <p class="text-muted font-13"><strong>Card Number :</strong> <span class="m-l-15">XXXX-XXXX-XXXX-{{$r->card_last_four}}</span></p>
                    
                </div>
                <div class="row">
                    <div class="col-md-6 mx-auto">
                        <a href="{{route('customer.payment.update_card')}}" class="btn btn-success">Update card information</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
    


    
    <!-- end col -->

</div>


@endsection

@section('footer_scripts')
<script type="text/javascript">
    function confirm_cancel(package){
        var x = confirm('Are you sure you want to cancel subscription ?');
        if(x == true){
            window.location.href='/customer/cancel-subscription/'+package;
        }
    }
    function confirm_cancel_now(package){
        var x = confirm('Are you sure you want cancel subscription now ?');
        if(x == true){
            window.location.href='/customer/cancel-subscription-now/'+package;
        }
    }
</script>
@stop