@extends('layouts.default')
@section('title','Notification - Edit')
@section('header_extra')
<link href="{{asset('assets/plugins/summernote/summernote.css')}}" rel="stylesheet" />
@stop

@section('content')


<div class="row">
    <div class="col-12">
        <div class="card-box">
            <h4 class="m-t-0 header-title"><b>Notification Edit</b></h4>
            <p class="text-muted m-b-30 font-14">
                Required Fields (<code>*</code>)
            </p>

            <div class="row">
                <div class="col-12">
                    <div class="p-20">
                        @include('widget/notifications')
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        
                        <form class="form-horizontal validate" action="{{route('admin.notification.edit_update',$r->id)}}" method="post" role="form" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Particular Customer</label>
                                <div class="col-8">
                                    <select class="form-control select2" name="to_id">
                                        <option value="">All Customer</option>
                                        @if(!empty($customer))
                                        @foreach($customer as $c)
                                        <option value="{{$c->id}}"  {{($c->id  == $r->to_id ? "selected":"")}}>{{$c->name.' '.$c->last_name.'('.$c->company_name.')' }}</option>
                                        @endforeach
                                        @endif
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Message <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <textarea class="form-control" name="message" required="">{{$r->message}}</textarea>
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">&nbsp;</label>
                               <div class="col-8">
                                    <div class="checkbox checkbox-primary">
                                        <input id="checkbox2" type="checkbox" name="dashboard" value="1" {{( $r->dashboard == "1" ? "checked":"")}}>
                                        <label for="checkbox2">
                                            Show Dashboard
                                        </label>
                                    </div>
                                </div>
                            </div>
                            
                            
                            <div class="form-group row">
                                <div class="col-8 offset-4">
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                                        Submit
                                    </button>
                                    
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('footer_scripts')
<script type="text/javascript" src="{{asset('assets/plugins/parsleyjs/parsley.min.js')}}"></script>
<script src="{{asset('assets/plugins/summernote/summernote.min.js')}}"></script>
<script type="text/javascript">
    $('.validate').parsley();
    $(function(){
        $(this).active_menu("subscription");
        
        
    });
    $('.summernote').summernote({
        height: 350,                 // set editor height
        minHeight: null,             // set minimum height of editor
        maxHeight: null,             // set maximum height of editor
        focus: false                 // set focus to editable area after initializing summernote
    });
    
</script>
@stop