<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;
use App\Http\Resources\ServiceOrders as ServiceOrdersResource;

class InvoiceList extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $admin_id = ownerKeyId(secret_key_get());
        return [
           
            'id' => encode($this->id),
            'orderEncyId'=> encode($this->order_id),
            'orderId'=> $this->order_id,
            'studentID' => encode($this->studentId),
            'studentName' => $this->student->name.' '.$this->student->last_name,
            'studentDateofbirth' => $this->student->dateOfbirth,
            'studentPhone' => $this->student->phone,
            'studentEmail' => $this->student->email,
            'studentAddress' => $this->student->address, 
            'studentCity' => $this->student->city, 
            'studentState' => $this->student->state, 
            'studentCountry' => $this->student->country,
            'studentZipcode' => $this->student->zipcode, 
            
            'invoiceId'=>  $this->invoice_id,
            'dateof' => $this->dateof,
            'items' => $this->items,
            'baseAmount'=>  $this->baseAmount,
            'amount' => $this->amount,
            'paymentType' =>  $this->paymentType,
            
            'taxRate1'=>  $this->taxRate1,
            'taxAmount1'=> $this->taxAmount1,
            'taxRate2' => $this->taxRate2,
            'taxAmount2' => $this->taxAmount2,
            'notes'=>  $this->notes,
            
            'grandTotal'=> $this->grand_total,
            'invoiceCreateBy' => getUserInfo($this->generatedBy,'name').' '.getUserInfo($this->generatedBy,'last_name'),
            'cancel'=>  $this->status_cancel,
            'cancelBy' =>getUserInfo($this->cancel_by,'name').' '.getUserInfo($this->cancel_by,'last_name'),
            'orderDetails'=> ServiceOrdersResource::collection(\App\Model\Api\Invoice\Orders::where('administer_id',$admin_id)->where('id',  $this->order_id)->get()),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
