<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use Auth;
use App\Model\Orders;


class OrdersController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    protected $common;
    public function __construct(){     
        $this->middleware('company.permissions');
        $this->common=new CommonController();
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */   
    
    public function show(){
        $content['pageConfigs'] = ['pageHeader' => true];
        $content['breadcrumbs'] = [
          ["link" => route('customer.home'), "name" => "Home"],["name" => "Orders"]
        ];
        return view('customer.orders.list',$content);
    }
    public function view($id){
        $content['breadcrumbs'] = [
          ["link" => route('customer.home'), "name" => "Home"],["link" => route('customer.order.manage'), "name" => "Orders - Manage"],["name" => "View"]
        ];
        $content['r']=  Orders::find($id);
        $content['invoice'] = \App\Model\Invoice::where('order_id',$id)->first();
        return view('customer.orders.view',$content);  
    }
    
    
    
    
    function showList(){        
        $record = Orders::with('user')->where('user_id',Auth::id());        
        return Datatables::of($record) 
          
           ->editColumn('payment_status',function($record) {
               if($record->payment_status == "Paid"){
                  return "<span class='label label-success'>Paid</span>";
               }else{
                   return "<span class='label label-danger'>".$record->payment_status."</span>";
               }
           })
           ->editColumn('service',function($record) {
               if($record->order_type == "1"){
                  return "<span class='label label-success'>Subscription</span>";
               }else{
                   return "<span class='label label-danger'>Setup Cost</span>";
               }
           })
           ->editColumn('status',function($record) {
              if($record->status == "2"){
                   return "<span class='label label-success'>Refund</span>";
               }elseif($record->status == "3"){
                   return "<span class='label label-danger'>Cancelled</span>";
               }
               else{
                   return "<span class='label label-info'>Completed</span>";
               }
               
            })    
            ->editColumn('created_at',function($record){
                return date('m-d-Y h:i A',  strtotime($record->created_at));
            })
            ->addColumn('actions',function($record) {
                $actions = '<a href="'. route('customer.order.view',$record->id).'" class="on-default"><i class="fa fa-pencil"></i></a> &nbsp;';
                
                return $actions;
            })
            ->rawColumns(['actions','status','payment_status','service'])
            ->make(true);            
    }   
    
}
