<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Task;
use App\User;
use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\Task as TaskResource;





class TaskController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){  
        $this->common=new CommonController();
    }

    
    function create(Request $request){
        
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'assignTo' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        
        $input = $request->all();
        $is_agent = User::where('id',  decode($input['assignTo']))->where('role',3)->count();
        if(!$is_agent){
            return response()->json(['error'=>"Invalid agent id"], 401);       
        }
        $input['assignTo'] = decode($input['assignTo']);
        $input['user_id']=Auth::id();
        $data = new Task($input);
        if($data->save()){
            return response()->json(['success'=>"Task has been created successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    function update(Request $request,$id){
        $id = decode($id);
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'assignTo' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        $is_agent = User::where('id',  decode($input['assignTo']))->where('role',3)->count();
        if(!$is_agent){
            return response()->json(['error'=>"Invalid agent id"], 401);       
        }
        
        
        $input['assignTo'] = decode($input['assignTo']);
        $data = Task::find($id);
        
        if($data->update($input)){
            return response()->json(['success'=>"Task has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    public function single($id=0){
        
        $id = decode($id);
        
        $list['data'] =  TaskResource::collection(Task::where('user_id',Auth::id())->where('id',$id)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function show(){
        $list['data'] =  TaskResource::collection(Task::has('user')->with('user')->where('user_id',Auth::id())->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function delete($id){
        $id = decode($id);
        $delete = Task::where('user_id',Auth::id())->where('id',$id)->delete();
        if($delete){
            return response()->json(['success'=>'Event has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    

    function status(Request $request,$id){
        $id = decode($id);
        $validator = Validator::make($request->all(), [
            'status' => 'required',
            'status' => 'in:Completed,Active,Processing,Cancel',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        $update['status'] = $input['status'];
        $update['notes'] = $input['notes'];
        $data = Task::where("id",$id)->where("assignTo",Auth::id());
        if($data->update($update)){
            return response()->json(['success'=>"Task status has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    public function showAgent(){
        $list['data'] =  TaskResource::collection(Task::has('user')->with('user')->where('assignTo',Auth::id())->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function showAgentSingle($id=0){
        $id = decode($id);
        $list['data'] =  TaskResource::collection(Task::has('user')->with('user')->where('assignTo',Auth::id())->where('id',$id)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    function message_errors(){
        return [
            'title.required'=> 'Title Required',
            'assignTo.required'=> 'Agent id is not valid',
            'status.required'=> 'Status Required',
            'status.in'=> 'Status should [Completed,Active,Processing,Cancel]',
        ];
    }
    
}
