<?php

namespace App\Http\Controllers\Api\Associate;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Notes;
use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\Notes as NotesResource;




class NotesController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){  
        $this->common=new CommonController();
    }

    
    function create(Request $request){
        
        $validator = Validator::make($request->all(), [
            'postTo' => 'required',
            'notes' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        
        $input = $request->all();
       
        
        $is_student = \App\User::where('id',  decode($input['postTo']))
                ->where('role',4)
                ->where('owner_key',Auth::user()->owner_key)
                ->count();
        
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);       
        }
        
        $input['postFrom']=Auth::id();
        $input['postTo'] = decode($input['postTo']);
        $data = new Notes($input);
        if($data->save()){
            return response()->json(['success'=>"Notes has been posted successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    function update(Request $request,$id){
        $id = decode($id);
        $validator = Validator::make($request->all(), [
            'postTo' => 'required',
            'notes' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        $is_student = \App\User::where('id',  decode($input['postTo']))
                ->where('role',4)
                ->where('owner_key',Auth::user()->owner_key)
                ->count();
        
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);       
        }
        
        
        $input['postTo'] = decode($input['postTo']);
        $data = Notes::find($id);
        if($data->update($input)){
            return response()->json(['success'=>"Note has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    function single($id){
        $id = decode($id);
        
        $list['data'] =  NotesResource::collection(Notes::has('user')->with('user')->where('postFrom',Auth::id())->where('id',$id)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function show(){
        $list['data'] =  NotesResource::collection(Notes::has('user')->with('user')->where('postFrom',Auth::id())->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function delete($id){
        $id = decode($id);
        $delete = Notes::where('postFrom',Auth::id())->where('id',$id)->delete();
        if($delete){
            return response()->json(['success'=>'Note has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
        
    }
    function message_errors(){
        return [
            'postTo.required'=> 'postTo ID is required',
            'notes.required'=> 'Notes value is required',
        ];
    }
    
}
