<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;


class ApplicationCollege extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [

            'id' => encode($this->id),
            'name' => $this->name,
            'type' => $this->type,
            'position' => $this->position,
            'status' => $this->status,
            'campus_details' => ($this->campus_details != '') ? json_decode($this->campus_details, true): '',
            'program_details' => ($this->program_details != '') ? json_decode($this->program_details, true): '',
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,

        ];
    }
}
