<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Leads;
use App\Model\Api\LeadsLog;
use App\Model\Api\Events;

use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\Users as UserResource;
use App\Http\Resources\Leads as LeadsResource;
use App\Http\Resources\LeadsLog as LeadslogResource;
use App\Http\Resources\LeadsLogSecond as LeadslogResourceSecond;
use DB;

class LeadsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){
        $this->common=new CommonController();
    }

    function create(Request $request){

        $validator = Validator::make($request->all(), [

            'service' =>'required',
            'actionSet' =>'required',
            'firstName'=>'required',
            //'email'=>'required|string|email|unique:users,email|unique:leads,email'
            'email'=>'required|string|email',
            'phoneNumber'=>'required'
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }

        if(userEmailExist($request->input('email'))){
            return response()->json(['error'=>'This email already register'], 401);
        }
        if(userPhoneExist($request->input('phoneNumber'))){
            return response()->json(['error'=>'This phone number already register as client'], 401);
        }
        if(getLeadEmailExist($request->input('email'))){
            return response()->json(['error'=>'This email already register'], 401);
        }
        if(getLeadPhoneExist($request->input('phoneNumber'))){
            return response()->json(['error'=>'This phone number already register'], 401);
        }



        /**/

        $input = $request->all();

        if(isset($input['custom_field_data'])) {
            $ss = json_decode($input['custom_field_data'], true);
            $sk = [];
            foreach($ss as $s) {
                $s['id'] = $s['id'];
                if($s['type'] == 'Date Picker' && $s['value'] != '') {
                    $s['value'] = change_date_format($s['value']);
                }
                array_push($sk, $s);
            }
            $comm['custom_field_data'] = json_encode($sk);
        }

        $comm['firstName'] = $input['firstName'];
        $comm['lastName'] = $input['lastName'];
        $comm['phoneNumber'] = $input['phoneNumber'];
        $comm['email'] = $input['email'];
        $comm['dob'] = $input['dob'];
        $comm['city'] = $input['city'];
        $comm['college'] = $input['college'];


        $comm['openBy'] =  Auth::id();
        $comm['source'] = $input['source'];
        $comm['service'] = $input['service'];
        $comm['notes'] = $input['service'];
        $comm['actionSet'] = $input['actionSet'];

        if($request->has('startDate')){
            $comm['startDate'] = $input['startDate'];
        }
        if($request->has('endDate')){
            $comm['endDate'] = $input['endDate'];
        }


        if($request->has('serviceInfo')){
            $comm['serviceInfo'] = $input['serviceInfo'];
        }


        if($request->has('status')){
            $comm['status'] = $input['status'];
        }
        if($request->has('appointmentBook')){
            $comm['appointmentBook'] = $input['appointmentBook'];
        }

        if($request->has('assignedTo')){
            $comm['assignedTo'] = decode($input['assignedTo']);

            if($request->input('assignedTo') !="Admin"){
                $comm['assignedTo'] = decode($input['assignedTo']);
            }else{
                $comm['assignedTo'] = ownerKeyId(secret_key_get());
            }
        }



        $comm['administer_id'] =  ownerKeyId(secret_key_get());
        //echo "<pre>"; print_r($comm); echo "</pre>"; die();

        $data = new Leads($comm);
        if($data->save()){


            /** Appointment */
            if($comm['actionSet'] == "Book an Appointment"){
                $inputAppData['administer_id'] = ownerKeyId(secret_key_get());
                $inputAppData['createdBy'] =Auth::id();
                $inputAppData['client_id'] = $data->id;
                $inputAppData['clientType'] = 'lead';
                $inputAppData['assignedTo'] = $comm['assignedTo'];
                $inputAppData['type'] = 'Appointment';
                $inputAppData['service'] = $input['service'];
                $inputAppData['startDate'] = $input['startDate'] ;
                $inputAppData['endDate'] =  $input['endDate'] ;
                $inputAppData['title'] = $input['source'].' -  Via Lead';
                $inputAppData['notes'] = $input['description'];
                $inputAppData['source'] = $input['source'];
                $dataApp = new Events($inputAppData); 
                $dataApp->save();

                if($request->has('startDate')){
                    $commLog['startDate'] = $input['startDate'];
                }
                if($request->has('endDate')){
                    $commLog['endDate'] = $input['endDate'];
                }
            }

            /*Leads ID update*/

            $commIdObj = Leads::find($data->id);
            $commId = rand(1, 10).$data->id.rand(1, 10);
            $commIdObj->leadUnique_id = $commId;
            $commIdObj->save();


                $commLog['leads_id'] = $data->id;
                $commLog['assignedBy'] = Auth::id();
                $commLog['assignedType'] = Auth::user()->role;

                if($request->hasFile('attachment')){
                    $commLog['attachment'] = $this->common->fileUpload($request->file('attachment'),'uploads/leads/');
                }

                if($request->has('assignedTo')){
                    if($request->input('assignedTo') !="Admin"){
                        $commLog['assignedTo'] = decode($input['assignedTo']);
                    }else{
                        $commLog['assignedTo'] = adminId(secret_key_get());
                    }
                }

                if($request->has('dueDateTime')){
                    $commLog['dueDateTime'] = $input['dueDateTime'];
                }else{
                    $commLog['dueDateTime'] = '';
                }



                $commLog['status'] = $input['status'];
                if($request->has('description')){
                    $commLog['description'] = $input['description'];
                }

                $commLog['replyBy'] = Auth::id();
                $commLog['replyByRole'] = Auth::user()->role;
                $commLog['notes'] = $input['notes'];
                $commLog['actionSet'] = $input['actionSet'];
                $dataLog = new LeadsLog($commLog);
                $dataLog->save();


            return response()->json(['success'=>"Leads record has been created successfully",'id'=>$commId,'recordID'=>encode($data->id)], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

    function update(Request $request,$id){

        $validator = Validator::make($request->all(), [

            'service' =>'required',
            'firstName'=>'required',
            'email'=>'required|string|email',
            'phoneNumber'=>'required'
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }


        if(userEmailExist($request->input('email'))){
            return response()->json(['error'=>'This email already register'], 401);
        }
        if(userPhoneExist($request->input('phoneNumber'))){
            return response()->json(['error'=>'This phone number already register as client'], 401);
        }
        if(getLeadEmailExist($request->input('email'),$id)){
            return response()->json(['error'=>'This email already register'], 401);
        }
        if(getLeadPhoneExist($request->input('phoneNumber'),$id)){
            return response()->json(['error'=>'This phone number already register'], 401);
        }

        $id = decode($id);

        $input = $request->all();

        if(isset($input['custom_field_data'])) {
            $ss = json_decode($input['custom_field_data'], true);
            $sk = [];
            foreach($ss as $s) {
                $s['id'] = $s['id'];
                if($s['type'] == 'Date Picker' && $s['value'] != '') {
                    $s['value'] = change_date_format($s['value']);
                }
                array_push($sk, $s);
            }
            $comm['custom_field_data'] = json_encode($sk);
        }

        if($request->has('source')){
            $comm['source'] = $input['source'];
        }

        if($request->has('service')){
            $comm['service'] = $input['service'];
        }

        $comm['notes'] = $input['service'];

        $comm['firstName'] = $input['firstName'];
        if($request->has('lastName')){
            $comm['lastName'] = $input['lastName'];
        }
        if($request->has('phoneNumber')){
            $comm['phoneNumber'] = $input['phoneNumber'];
        }
        if($request->has('dob')){
            $comm['dob'] = $input['dob'];
        }
        $comm['email'] = $input['email'];
        if($request->has('city')){
            $comm['city'] = $input['city'];
        }
        if($request->has('college')){
            $comm['college'] = $input['college'];
        }
        if($request->has('serviceInfo')){
            $comm['serviceInfo'] = $input['serviceInfo'];
        }

        if($request->has('appointmentBook')){
            $comm['appointmentBook'] = $input['appointmentBook'];
        }

        $data = Leads::find($id);
        if($data->update($comm)){
            return response()->json(['success'=>"Record has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    public function single($id=0){
        $id = decode($id);
        $query = Leads::where('id',$id)->where('administer_id',ownerKeyId(secret_key_get()));

        $list['data'] =  LeadsResource::collection($query->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    public function show(Request $request){


        $query = Leads::where('convertStatus',0)->where('administer_id',ownerKeyId(secret_key_get()));

        if(count($request->all())){

            if($request->has('start_date') && $request->has('end_date')){
                if($request->input('start_date') == $request->input('end_date')) {
                    $query->where(DB::raw('DATE(created_at)'), $request->input('start_date'));
                } else {
                    $query->whereBetween('created_at', [$request->input('start_date'), $request->input('end_date')]);
                }
                
            }
            if($request->has('firstName')){
                $query->where('firstName','like', '%'.$request->input('firstName').'%');
            }
            if($request->has('lastName')){
                $query->where('lastName','like', '%'.$request->input('lastName').'%');
            }
            if($request->has('email')){
                $query->whereRaw('LOWER(email) like ?',strtolower($request->input('email')));
            }
            if($request->has('phoneNumber')){
                $query->where('phoneNumber', 'like', '%'.$request->input('phoneNumber').'%');
            }
            if($request->has('leadUniqueId')){
                $query->where('leadUnique_id',$request->input('leadUniqueId'));
            }

            if($request->has('assignedTo')){
                $query->where('assignedTo',decode($request->input('assignedTo')));
            }

            if($request->has('service')){
                $query->where('service',$request->input('service'));
            }

            if($request->has('action')){
                $query->where('actionSet',$request->input('action'));
            }

            if($request->has('status')){
                $query->where('status',$request->input('status'));
            }
            $limit = 10;
            if($request->has('limit')){
                $limit = $request->input('limit');
            }
        }
        if($request->get('page')){
            $list =  LeadsResource::collection($query->orderBy('id','desc')->paginate($limit))->response()->getData();
        }else{
           $list['data'] =  LeadsResource::collection($query->get());
        }

        return response()->json(['success'=>$list], $this->successStatus);
    }

    function message_errors(){
        return [
            'firstName.required'=> 'First Name rquired',
            'email.unique'=>'This email already exist',
            'email.email'=>'Invalid Email',
            'source'=>'Source value required',
            'service'=>'Service value required',
            'actionSet'=>'Action value required',
            'actionSet.in'=> 'Action value must be [Follow Up,Call Back Requested,No Action Required]'

        ];
    }

    function is_agent_belong($id=0){
        return Leads::where("id",$id)->where('assignedTo',Auth::id())->count();
    }

    function logCreate(Request $request,$id){
        $id = decode($id);

        $commPrvMain = Leads::where('id',$id)->first();
        $input = $request->all();
//        if(Auth::user()->role == 3 ){
//            if(!$this->is_agent_belong($id)){
//                return response()->json(['error'=>"You have no access to post the data. "], 401);
//            }
//        }



        $comm['actionSet'] = $input['actionSet'];
        $comm['status'] = $input['status'];
        if($request->has('assignedTo') && $input['assignedTo']!=""){

            if($input['assignedTo'] !="Admin"){
                $comm['assignedTo'] = decode($input['assignedTo']);
            }else{
                $comm['assignedTo'] = adminId(secret_key_get());
            }

        }else{
            $comm['assignedTo'] = $commPrvMain->assignedTo;
        }

        if($request->has('startDate')){
            $comm['startDate'] = $input['startDate'];
        }else{
            $comm['startDate'] = '';
        }
        if($request->has('endDate')){
            $comm['endDate'] = $input['endDate'];
        }else{
            $comm['endDate'] = '';
        }


        $data = Leads::find($id);
        if($data->update($comm)){


             /** Appointment */
             if($comm['actionSet'] == "Book an Appointment"){
                
                $inputAppData['administer_id'] = ownerKeyId(secret_key_get());
                $inputAppData['createdBy'] =Auth::id();
                $inputAppData['client_id'] = $data->id;
                $inputAppData['clientType'] = 'lead';
                $inputAppData['assignedTo'] = $comm['assignedTo'];
                $inputAppData['type'] = 'Appointment';
                $inputAppData['service'] = $data->service;
                $inputAppData['startDate'] = $input['startDate'] ;
                $inputAppData['endDate'] =  $input['endDate'] ;
                $inputAppData['title'] = $input['description'].' -  Via Lead';
                $inputAppData['notes'] = $data->notes;
                $inputAppData['source'] = $data->source;


                $dataApp = new Events($inputAppData); 
                $dataApp->save();

                if($request->has('startDate')){
                    $commLog['startDate'] = $input['startDate'];
                }
                if($request->has('endDate')){
                    $commLog['endDate'] = $input['endDate'];
                }
            }


            $commLogPrev = LeadsLog::where('leads_id',$id)->latest()->first();
            $commLog['leads_id'] = $id;


               if($request->has('assignedTo') && $input['assignedTo']!=""){
                    $commLog['assignedBy'] = Auth::id();
                    $commLog['assignedType'] = Auth::user()->role;

                    if($input['assignedTo'] !="Admin"){
                        $commLog['assignedTo'] = decode($input['assignedTo']);
                    }else{
                        $commLog['assignedTo'] = adminId(secret_key_get());
                    }
               }else{

                   $commLog['assignedBy'] = $commLogPrev->assignedBy;
                   $commLog['assignedType'] = $commLogPrev->assignedType;
                   $commLog['assignedTo'] = $commLogPrev->assignedTo;

               }



                if($request->hasFile('attachment')){
                    $commLog['attachment'] = $this->common->fileUpload($request->file('attachment'),'uploads/leads/');
                }

                $commLog['dueDateTime'] = $input['dueDateTime'];
                $commLog['status'] = $input['status'];
                $commLog['description'] = $input['description'];

                $commLog['replyBy'] = Auth::id();
                $commLog['replyByRole'] = Auth::user()->role;
                $commLog['notes'] = $input['notes'];
                $commLog['actionSet'] = $input['actionSet'];

                $dataLog = new LeadsLog($commLog);
                $dataLog->save();


            return response()->json(['success'=>"Record has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

    function convert($id=''){
        $id = decode($id);

        $info = Leads::where('id',$id)->first();

        if(!empty($info)){
            if(userEmailExist($info->email)){
                return response()->json(['error'=>'This email already register as client'], 401);
            }
            if(userPhoneExist($info->phoneNumber)){
                return response()->json(['error'=>'This phone number already register as client'], 401);
            }

            $input['password'] = Hash::make($info->email);
            $input['agent_id']=0;
            $input['role'] = 4;
            $input['status'] = 1;
            $input['owner_key']=secret_key_get();
            $input['name'] =$info->firstName;
            $input['last_name'] =$info->lastName;
            $input['email'] =$info->email;
            if($info->dob!=""){
                $input['dateOfbirth'] = date('Y-m-d',  strtotime($info->dob)) ;
            }

            $input['city'] =$info->city;
            $input['phone'] =$info->phoneNumber;
            $user = \App\User::create($input);

            $success['Authorization'] =  $user->createToken('MyApp')->accessToken;
            $success['name'] =  $user->name;
            $success['role'] = "Student";
            $success['status'] = "Active";
            $success['student_id'] = encode($user->id);

            /*Convert status update*/

            $leadStatus['convertStatus']=1;
            $leadStatus['convertBy']= Auth::id();

            $leadUpdate = Leads::find($info->id);
            $leadUpdate->update($leadStatus);

            return response()->json(['success'=>$success], $this->successStatus);



        }else{
            return response()->json(['error'=>'This record not found in db'], 401);
        }



    }

    function viewProfile($email=''){
        $query = Leads::where('email',$email);
        $list['data'] =  LeadsResource::collection($query->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    public function show_logs(Request $request){

        $query = LeadsLog::whereHas('leads_rel',function($q){

                $q->where('convertStatus',0)->Where('administer_id',ownerKeyId(secret_key_get()));
        });
        if(count($request->all())){
            if($request->has('follow_date')){
                $query->whereDate('dueDateTime','=', $request->input('follow_date'));
            }
            if($request->has('followstatus')){
                if($request->input('followstatus') !="all"){
                    $query->where('followStatus', $request->input('followstatus'));
                }
                
            }

            if($request->has('assignedto') && $request->input('assignedto')!=""){
                if($request->input('assignedto') !="Admin"){
                    $query->where('assignedTo',decode($request->input('assignedto')));
                }else{
                    $query->where('assignedTo',adminId(secret_key_get()));
                }
            }
            
        }

        $list['data'] =  LeadslogResourceSecond::collection($query->orderBy('dueDateTime','desc')->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    function log_status_update(Request $request,$id){

        $id = decode($id);
        $input = $request->all();
        $comm['followStatus'] = $input['followstatus'];

        $data = LeadsLog::find($id);
        if($data->update($comm)){
            return response()->json(['success'=>"Record has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }


    function multipleLogCreate(Request $request,$id){
        $ids = explode(",", $id);
        $arr = [];
        foreach($ids as $id) {
            $id = decode($id);
            $commPrvMain = Leads::where('id',$id)->first();
            $input = $request->all();
            $comm['actionSet'] = $input['actionSet'];
            $comm['status'] = $input['status'];
            if($request->has('assignedTo') && $input['assignedTo']!=""){
                if($input['assignedTo'] !="Admin"){
                    $comm['assignedTo'] = decode($input['assignedTo']);
                }else{
                    $comm['assignedTo'] = adminId(secret_key_get());
                }
            }else{
                $comm['assignedTo'] = $commPrvMain->assignedTo;
            }
            if($request->has('startDate')){
                $comm['startDate'] = $input['startDate'];
            }else{
                $comm['startDate'] = '';
            }
            if($request->has('endDate')){
                $comm['endDate'] = $input['endDate'];
            }else{
                $comm['endDate'] = '';
            }
            $data = Leads::find($id);
            if($data->update($comm)){
                /** Appointment */
                if($comm['actionSet'] == "Book an Appointment"){
                    $inputAppData['administer_id'] = ownerKeyId(secret_key_get());
                    $inputAppData['createdBy'] =Auth::id();
                    $inputAppData['client_id'] = $data->id;
                    $inputAppData['clientType'] = 'lead';
                    $inputAppData['assignedTo'] = $comm['assignedTo'];
                    $inputAppData['type'] = 'Appointment';
                    $inputAppData['service'] = $data->service;
                    $inputAppData['startDate'] = $input['startDate'] ;
                    $inputAppData['endDate'] =  $input['endDate'] ;
                    $inputAppData['title'] = $input['description'].' -  Via Lead';
                    $inputAppData['notes'] = $data->notes;
                    $inputAppData['source'] = $data->source;
                    $dataApp = new Events($inputAppData); 
                    $dataApp->save();
                    if($request->has('startDate')){
                        $commLog['startDate'] = $input['startDate'];
                    }
                    if($request->has('endDate')){
                        $commLog['endDate'] = $input['endDate'];
                    }
                }
                $commLogPrev = LeadsLog::where('leads_id',$id)->latest()->first();
                $commLog['leads_id'] = $id;
                if($request->has('assignedTo') && $input['assignedTo']!=""){
                    $commLog['assignedBy'] = Auth::id();
                    $commLog['assignedType'] = Auth::user()->role;
                    if($input['assignedTo'] !="Admin"){
                        $commLog['assignedTo'] = decode($input['assignedTo']);
                    }else{
                        $commLog['assignedTo'] = adminId(secret_key_get());
                    }
                }else{
                   $commLog['assignedBy'] = $commLogPrev->assignedBy;
                   $commLog['assignedType'] = $commLogPrev->assignedType;
                   $commLog['assignedTo'] = $commLogPrev->assignedTo;
                }
                if($request->hasFile('attachment')){
                    $commLog['attachment'] = $this->common->fileUpload($request->file('attachment'),'uploads/leads/');
                }
                $commLog['dueDateTime'] = $input['dueDateTime'];
                $commLog['status'] = $input['status'];
                $commLog['description'] = $input['description'];
                $commLog['replyBy'] = Auth::id();
                $commLog['replyByRole'] = Auth::user()->role;
                $commLog['notes'] = $input['notes'];
                $commLog['actionSet'] = $input['actionSet'];
                $dataLog = new LeadsLog($commLog);
                $dataLog->save();


                array_push($arr, $id);
                //return response()->json(['success'=>"Record has been updated successfully"], $this->successStatus);
            }
        }
        return response()->json(['success'=>$arr], $this->successStatus);
        exit();

    }


    function multipleLogDelete($id){
        $ids = explode(",", $id);
        $arr = [];
        foreach($ids as $id) {
            $id = decode($id);
            array_push($arr, $id);
        }
        Leads::where('administer_id', ownerKeyId(secret_key_get()))->whereIn('id', $arr)->delete();
        LeadsLog::whereIn('leads_id', $arr)->delete();
        Events::where('clientType', 'lead')->whereIn('client_id', $arr)->delete();
    }

}
