<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Events;
use Validator;
use Illuminate\Support\Facades\Hash;
use App\Http\Resources\Events as EventsResource;




class EventsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){
        $this->common=new CommonController();
    }

    function create(Request $request){

        $validator = Validator::make($request->all(), [
            'startDate' => 'required|date_format:Y-m-d H:i',

            'title' =>'required',
            'type' =>'required|in:Task,Reminder,Appointment',
            'cleintType'=>'in:profile,lead',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }

        $input = $request->all();

        $input['administer_id'] =  ownerKeyId(secret_key_get());
        $input['createdBy']=Auth::id();


        if($request->has('client_id')){
            $input['client_id'] = decode($input['client_id']);
            if($request->has('clientType')){
                if($request->input('clientType') == ""){
                    $input['clientType']= 'profile';
                }
            }
        }


        if($request->input('assignedTo') !="Admin"){
            $input['assignedTo'] = decode($request->input('assignedTo'));
        }else{
            $input['assignedTo'] = ownerKeyId(secret_key_get());
        }

        //echo "<pre>"; print_r($input); die();

        $data = new Events($input);
        if($data->save()){
            return response()->json(['success'=>"Record has been created successfully",'recordId'=>encode($data->id)], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

    function update(Request $request,$id){
        $id = decode($id);
        $validator = Validator::make($request->all(), [
            'startDate' => 'required|date_format:Y-m-d H:i',
            'endDate' => 'date_format:Y-m-d H:i',
            'cleintType'=>'in:profile,lead',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }

        $input = $request->all();

        if($request->has('client_id')){
            $input['client_id'] = decode($input['client_id']);
            if($request->has('clientType')){
                if($request->input('clientType') == ""){
                    $input['clientType']= 'profile';
                }
            }
        }

        if($request->input('assignedTo') !="Admin"){
            $input['assignedTo'] = decode($input['assignedTo']);
        }else{
            $input['assignedTo'] = ownerKeyId(secret_key_get());
        }

        $data = Events::find($id);
        if($data->update($input)){
            return response()->json(['success'=>"Record has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

    public function show(){

        if(Auth::user()->role == "5" || Auth::user()->role == "2" || Auth::user()->role == "6" ){
            //$list1 =  EventsResource::collection(Events::where('administer_id',ownerKeyId(secret_key_get()))->where('type','Appointment')->get());
            //$list2 =  EventsResource::collection(Events::where('assignedTo',Auth::id())->where('administer_id',ownerKeyId(secret_key_get()))->get());
            //$list['data'] = $list1->merge($list2);
            $list['data'] = EventsResource::collection(Events::where('administer_id',ownerKeyId(secret_key_get()))->where(function($query){
                $query->where('type','Appointment')
                    ->orWhere('assignedTo',Auth::id());
            })->get());
        }else{
            $list['data'] =  EventsResource::collection(Events::where('assignedTo',Auth::id())->where('administer_id',ownerKeyId(secret_key_get()))->get());
        }

        return response()->json(['success'=>$list], $this->successStatus);
    }
    function customList(Request $request){
        $administer_id =  ownerKeyId(secret_key_get());
        $query = Events::where('administer_id',$administer_id);
        if(count($request->all())){
            if($request->has('type')){
                $query->where('type', $request->input('type'));
                if($request->input('type') == "Task"){
                    if(Auth::user()->role != "2"){
                            $query->where('assignedTo',Auth::id());
                    }
                }
            }
            if($request->has('nonExpire')){
                $query->where('endDate','>=','CURDATE()');
            }

        }

        if($request->get('page')){
            $list =  EventsResource::collection($query->orderBy('id','desc')->paginate(10))->response()->getData();
        }else{
           $list['data'] =  EventsResource::collection($query->get());
        }
        return response()->json(['success'=>$list], $this->successStatus);

    }
    public function single($id=''){
        $id = decode($id);
        if(Auth::user()->role == "5" || Auth::user()->role == "2" || Auth::user()->role == "6" || Auth::user()->role == 7){
            $list['data'] =  EventsResource::collection(Events::where('administer_id',ownerKeyId(secret_key_get()))->where('id',$id)->get());
        }else{
            //$list['data'] =  EventsResource::collection(Events::where('administer_id',ownerKeyId(secret_key_get()))->where('assignedTo',Auth::id())->where('id',$id)->get());
            $list['data'] =  EventsResource::collection(Events::where('administer_id',ownerKeyId(secret_key_get()))->where('id',$id)->get());
        }

        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function delete($id){
        $id = decode($id);
        $delete = Events::where('administer_id',ownerKeyId(secret_key_get()))->where('id',$id)->delete();
        if($delete){
            return response()->json(['success'=>'Record has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

    function message_errors(){
        return [
            'title.required'=> 'Title Required',
            'startDate.required'=> 'Please provide the valid start date',
            'startDate.date_format'=> 'Date format should be (YYYY-MM-DD H:M)',
            'endDate.date_format'=> 'Date format should be (YYYY-MM-DD H:M)',
            'type.required'=> 'Type Required',
            'type.in'=> 'Type should be [Task ,Reminder,Appointment]',
            'remind_rpeat.in' =>'Reminder should be [Daily,Weekly,Month,Year,Custom]',
            'cleintType.in' =>'Client should be [profile,lead]'
        ];
    }

}
