<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\EmailTemplate;

use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;

use App\Http\Resources\EmailTemplate as EmailTemplateResource;




class EmailTemplateController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){
        $this->common=new CommonController();
    }

    function create(Request $request){

        $validator = Validator::make($request->all(), [
            'subject' => 'required',
            'message' => 'required',
        ],  $this->message_errors());

        if(Auth::user()->role != 2){
            return response()->json(['error'=>"Invalid access"], 401);
        }

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        $input = $request->all();
        $input['administer_id'] =  ownerKeyId( secret_key_get() );
        
        $data = new EmailTemplate($input);
        if($data->save()){
            return response()->json(['success'=>"Email Template has been created successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    function update(Request $request,$id){
        $id = decode($id);
        $validator = Validator::make($request->all(), [
            'subject' => 'required',
            'message' => 'required',
            'status' =>'required',
        ],  $this->message_errors());
        if(Auth::user()->role != 2){
            return response()->json(['error'=>"Invalid access"], 401);
        }
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        $input['status'] = $request->input('status');
        $input['subject'] = $request->input('subject');
        $input['message'] = $request->input('message');
        $data = EmailTemplate::find($id);
        if($data->update($input)){
            return response()->json(['success'=>"Email template has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    public function single($id=0){
        $id = decode($id);
        $list['data'] =  EmailTemplateResource::collection(EmailTemplate::where('administer_id', ownerKeyId( secret_key_get() ))->where('id',$id)->where('status',1)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    public function show(Request $request){
        $list['data'] =  EmailTemplateResource::collection(EmailTemplate::where('administer_id', ownerKeyId( secret_key_get() ))->where('status',1)->orderBy('id', 'asc')->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function show_filter(Request $request){
        
        if(count($request->all())){
            if($request->input('status')){
                $query = EmailTemplate::where('administer_id', ownerKeyId( secret_key_get() ))->where('id',$request->input('status'))->orderBy('id', 'asc');
            }else{
                $query = EmailTemplate::where('administer_id', ownerKeyId( secret_key_get() ))->orderBy('id', 'asc');
            }
            
        }else{
            $query = EmailTemplate::where('administer_id', ownerKeyId( secret_key_get() ))->orderBy('id', 'asc');
        }
        $list['data'] =  EmailTemplateResource::collection($query->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    
    function message_errors(){
        return [
            'name'=>'Status name required',
            'status'=>'Status required',
        ];
    }

}
