<?php

namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\CommonController;
use App\User;
use Auth;
use Illuminate\Support\Facades\Hash;
use App\Http\Resources\Users as UserResource;
use Validator;
use App\Http\Resources\Instruction as InstructionsResource;
use App\Http\Resources\Email as EmailResource;
use App\Model\Api\Application;
use App\Http\Resources\Application as ApplicationResource;
use App\Http\Resources\Communication as CommunicationResource;
use Illuminate\Support\Facades\DB;
use App\Http\Resources\Leads as LeadsResource;
use App\Model\Api\Leads;


class CronController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    public $headers = '';
    public function __construct()
    {
        $this->headers = apache_request_headers();
        $this->common=new CommonController();
    }

    
    /*Cron JOB*/
    function users(){
        $user = User::where('role',2)->where('secret_key',$this->headers['Secret-Key'])->first();
        
        if($user){
            $list['data'] = User::where('owner_key',$user->secret_key)->where('role',4)->get();
            return response()->json(['success'=>$list], $this->successStatus);
        }else{
            return response()->json(['error'=>"Invalid request"], $this->successStatus);
        }
    }
    function application(){
        $secret_key = $this->headers['Secret-Key'];
        $query = Application::where('administer_id',ownerKeyId($secret_key))->get();
        $list['data'] = $query;
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    function interaction(){
        $secret_key = $this->headers['Secret-Key'];
        
        $result =  CommunicationResource::collection(\App\Model\Api\Communication::has('user')->with('user')->where('administer_id',ownerKeyId($secret_key))->get());
        $list['data'] = $result;
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    function lead(){
        $secret_key = $this->headers['Secret-Key'];
        $result =  LeadsResource::collection(Leads::where('convertStatus',0)->where('administer_id',ownerKeyId($secret_key))->get());
        $list['data'] = $result;
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    /*Duplicate Email exist*/
    
    function fieldExist(Request $request){
        
        $exist ='';
        if($request->has('exist')){
            $exist = $request->input('exist');
        }
        
        if($request->has('emails')){
            
            $resultUser = userEmailExist($request->input('emails'));
            if($resultUser){
                return response()->json(['status'=>$resultUser,'column' => 'email','message'=>'This email already register as permanent user'], $this->successStatus);
            }
        }
        
        if($request->has('phone')){
            
            $resultUser = userPhoneExist($request->input('phone'));
            if($resultUser){
                return response()->json(['status'=>$resultUser,'column' => 'phone','message'=>'This phone number already register as permanent user'], $this->successStatus);
            }
        }
        
        
        
        
        if($request->has('lead')){
            if($request->has('emails')){
                $result = getLeadEmailExist($request->input('emails'),$exist);
                if($result){
                    return response()->json(['status'=>$result,'column' => 'email','message'=>'This email already exist in lead'], $this->successStatus);
                }
            }
            
            if($request->input('phone')){
                $result = getLeadPhoneExist($request->input('phone'),$exist); 
                if($result){
                    return response()->json(['status'=>$result,'column' => 'phone','message'=>'This phone number already exist in lead'], $this->successStatus);
                }
            }
            return response()->json(['status'=>0,'message'=>'Can enter'], $this->successStatus);
            
        }
        
    }
    
    
    
    
}
