<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\ApplicationCollege;

use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;

use App\Http\Resources\ApplicationCollege as ApplicationCollegeResource;




class ApplicationCollegeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){
        $this->common=new CommonController();
    }

    function create(Request $request){

        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'type' => 'required',
        ],  $this->message_errors());

        if(Auth::user()->role != 2){
            return response()->json(['error'=>"Invalid access"], 401);
        }

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        $input = $request->all();
        $input['administer_id'] =  ownerKeyId( secret_key_get() );
        if($input['position'] == ''){
            $input['position'] = 0;
        }
        
        $data = new ApplicationCollege($input);
        if($data->save()){
            return response()->json(['success'=>"College has been added successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    function update(Request $request,$id){
        $id = decode($id);
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'type' => 'required',
            'status' =>'required',
        ],  $this->message_errors());
        if(Auth::user()->role != 2){
            return response()->json(['error'=>"Invalid access"], 401);
        }
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        $input['status'] = $request->input('status');
        $input['name'] = $request->input('name');
        $input['type'] = $request->input('type');
        $input['campus_details'] = $request->input('campus_details');
        $input['program_details'] = $request->input('program_details');
        if($request->input('position') == ''){
            $input['position'] = 0;
        } else {
            $input['position'] = $request->input('position');
        }
        $data = ApplicationCollege::find($id);
        if($data->update($input)){
            return response()->json(['success'=>"College has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    public function single($id=0){
        $id = decode($id);
        $list['data'] =  ApplicationCollegeResource::collection(ApplicationCollege::where('administer_id', ownerKeyId( secret_key_get() ))->where('id',$id)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    public function search_by_name_single(Request $request){
        //$id = decode($id);
        $list['data'] =  ApplicationCollegeResource::collection(ApplicationCollege::where('administer_id', ownerKeyId( secret_key_get() ))->where('name', $request->input('college_name'))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    public function show(Request $request){
        $list['data'] =  ApplicationCollegeResource::collection(ApplicationCollege::where('administer_id', ownerKeyId( secret_key_get() ))->where('status',1)->orderBy('position', 'asc')->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function show_filter(Request $request){
        
        if(count($request->all())){
            if($request->input('status')){
                $query = ApplicationCollege::where('administer_id', ownerKeyId( secret_key_get() ))->where('id',$request->input('status'))->orderBy('position', 'asc');
            }else{
                $query = ApplicationCollege::where('administer_id', ownerKeyId( secret_key_get() ))->orderBy('position', 'asc');
            }
            
        }else{
            $query = ApplicationCollege::where('administer_id', ownerKeyId( secret_key_get() ))->orderBy('position', 'asc');
        }
        $list['data'] =  ApplicationCollegeResource::collection($query->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    
    function message_errors(){
        return [
            'name'=>'College name required',
            'type'=>'Type name required',
            'status'=>'Status required',
        ];
    }

}
