<?php

namespace App\Http\Controllers\Customer;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\CommonController;
use App\User;
use Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Hash;




class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('company.permissions');
        $this->common=new CommonController();
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(){
        $content['pageConfigs'] = ['pageHeader' => true];
        $content['breadcrumbs'] = [
          ["link" => route('customer.home'), "name" => "Home"],["name" => "My Profile"]
        ];
        return view('home',$content);
    }
    
    
    function profile(){
        
        $content['pageConfigs'] = ['pageHeader' => true];
        $content['breadcrumbs'] = [
          ["link" => route('customer.home'), "name" => "Home"],["name" => "My Profile"]
        ];
        $content['r'] = User::where('id',Auth::id())->first();
        return view('customer.profile',$content);
    }
    function packages(){
        $content['pageConfigs'] = ['pageHeader' => true];
        $content['breadcrumbs'] = [
          ["link" => route('customer.home'), "name" => "Home"],["name" => "Packages"]
        ];
        $content['record'] = \App\Model\Package::where('status',1)->where('type',1)->get();
        return view('customer.package',$content);
    }
    function profile_edit(){
        
        
       
        $content['pageConfigs'] = ['pageHeader' => true];
        $content['breadcrumbs'] = [
          ["link" => route('customer.home'), "name" => "Home"],["link" => route('customer.profile'),"name" => "My Profile"],["name" => "Edit"]
        ];
        $content['r'] = User::where('id',Auth::id())->first();
        $content['country'] = \App\Model\Country::get();
        return view('customer.profile_edit',$content);
    }
    function profile_update(Request $request){
        
        $request->validate([
            'name' => 'bail|required',
            'email' => 'required|string|email|unique:users,email,'.Auth::id(),
            'company_name'=>'required',
            'phone'=>'required',
            'address'=>'required',
            'country'=>'required',
            'zipcode'=>'required'
        ]);
        
        $form_data = $request->all();  
        if($request->file('picture')){             
            $form_data['picture']=  $this->common->fileUpload($request->file('picture'),  './uploads/profile',1 );
        }
        if($request->input('new_password')!=""){
            
            $error = array();
            if($request->input('new_password') != $request->input('password_confirmation')){
                $error[] = "Confirm password does not match";
            }
            
            if( !password_verify($request->input('current_password'),Auth::user()->password) ){
                $error[] = "Current password does not match";
            }
            if(!empty($error)){
                return Redirect::back()->withErrors($error);
            }
            
            $form_data['password'] = bcrypt($request->input('new_password'));
        }
        $data =  User::find(Auth::id());
        if($data->update($form_data)){
            $request->session()->flash('success', 'Profile has been updated successfully!');
            return redirect(route('customer.profile_edit'));
        }else{
            $request->session()->flash('error', 'Error!');
            return redirect(route('customer.profile_edit'));
        }
    }
    function secret_key(){
        $content['breadcrumbs'] = [
          ["link" => route('customer.home'), "name" => "Home"],["name" => "Secret Key"]
        ];
        return view('customer.secret_key',$content);
    }
    function key_generate(){
        
        $data=User::find(Auth::id());
        $oldSecret = Auth::user()->secret_key;
        
        $encrypted = md5(encrypt(Auth::id()));
        $data->secret_key=$encrypted;
        
        if($data->save()){
            
            if($oldSecret !=""){
                $this->common->keyUpdateAll($oldSecret,$encrypted);
            }
            Session::flash('success', 'Key has been generated successfully!');
            return redirect(route('customer.secret_key'));
        }else{
            Session::flash('error', 'Error!');
            return redirect(route('customer.secret_key'));
        }
    }
}
