<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Validator;
use Illuminate\Support\Facades\Cookie;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/admin/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
    function loginform(Request $request){ 
        $data['email'] = Cookie::get('login_email');
        $data['password'] = Cookie::get('login_password');
        return view('auth/login',$data);
    }
    public function login(Request $request) {    
        
         $this->validate($request, [
            'email' => 'required|string|email|max:255', 
            'password' => 'required|string|min:6',
            ]
        
          );   
        
        $remember = ($request->input('remember')) ? true : false;  
        
        $email=$request->input('email');
        $password=$request->input('password');
        
        $auth = Auth::attempt(
            [
                'email'  => strtolower($request->input('email')),
                'password'  => $request->input('password'),
                'status' => 1,            
            ], $remember
        ); 
        
        if($auth){  
            
            if($remember){    
                
                Cookie::queue("login_email", $email);
                Cookie::queue("login_password", $password);
            }
            
            session_start();
            $_SESSION['user_id']=Auth::id();
            if(Auth::user()->role=='1'){
                return redirect(route('admin.profile'));
            }elseif(Auth::user()->role=='2'){
                return redirect(route('customer.profile'));
            }     
            
        }else{           
            $request->session()->flash('error', 'Your email/password combination was incorrect.!');
            return redirect(route('login'));
        }
        
    }
    function logout(Request $request) {
        Auth::logout();
        session_start();        
        session_destroy();        
        return redirect(route('login'));
    }
}
